/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.ssl.a;
import oracle.security.pki.ssl.b;

final class h
implements b {
    Vector a = new Vector();
    static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    h(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        Vector vector = new Vector(keyStore.size());
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            if (keyStore.getCertificate(string) instanceof OraclePKIX509CertImpl) {
                this.a.add(keyStore.getCertificate(string));
                oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            if (!(keyStore.getCertificate(string) instanceof X509Certificate)) continue;
            try {
                X509 x509 = new X509(((X509Certificate)keyStore.getCertificate(string)).getEncoded());
                this.a.addElement(new OraclePKIX509CertImpl(x509));
                oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            catch (Exception exception) {
                oracle.security.pki.ssl.a.a("OracleX509TrutManagaer: Invalid cert at alias " + string);
            }
        }
        oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Trust Manager Created");
    }

    private final OraclePKIX509CertImpl a(X509Certificate x509Certificate) {
        oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Looking for trusted certificate: " + x509Certificate.getSubjectDN());
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.a.elementAt(i2);
            oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Is it : " + oraclePKIX509CertImpl + " ? " + ((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN()));
            if (!((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN())) continue;
            return oraclePKIX509CertImpl;
        }
        return null;
    }

    public final void a(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        int n2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException(b.getString("PKI-07004"));
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        boolean bl = false;
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>();
        try {
            vector.addElement(new OraclePKIX509CertImpl(new X509(x509CertificateArray[0].getEncoded())));
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(0);
            block4: for (int i2 = 1; i2 < x509CertificateArray.length; ++i2) {
                oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(i2 - 1);
                oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Looking for signer of:  " + oraclePKIX509CertImpl.getSubjectDN());
                OraclePKIX509CertImpl oraclePKIX509CertImpl2 = this.a(oraclePKIX509CertImpl);
                if (oraclePKIX509CertImpl2 != null) {
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl2.getX509());
                    bl = true;
                    break;
                }
                for (int i3 = 1; i3 < x509CertificateArray.length; ++i3) {
                    oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Is it : " + x509CertificateArray[i3].getSubjectDN() + " ? " + ((Object)oraclePKIX509CertImpl.getIssuerDN()).equals(x509CertificateArray[i3].getSubjectDN()));
                    if (!((Object)oraclePKIX509CertImpl.getIssuerDN()).equals(x509CertificateArray[i3].getSubjectDN())) continue;
                    X509 x509 = new X509(x509CertificateArray[i3].getEncoded());
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(x509);
                    vector.addElement(new OraclePKIX509CertImpl(x509));
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            throw new CertificateException("Invalid certificate in chain");
        }
        oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(vector.size() - 1);
        oracle.security.pki.ssl.a.a("OracleX509CertTrustManager: Trying to complete the chain ending with: " + oraclePKIX509CertImpl.getIssuerDN());
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = this.a(oraclePKIX509CertImpl);
        if (oraclePKIX509CertImpl3 != null) {
            oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl3.getX509());
            vector.addElement(oraclePKIX509CertImpl3);
            bl = true;
        }
        if (!bl) {
            throw new CertificateException(b.getString("PKI-07005"));
        }
        oraclePKIX509CertImplArray = vector.toArray(new OraclePKIX509CertImpl[vector.size()]);
        oracle.security.pki.ssl.a.a("Checking Dates of Certificates");
        for (n2 = 0; n2 < oraclePKIX509CertImplArray.length - 1; ++n2) {
            x509CertificateArray[n2].checkValidity();
        }
        oracle.security.pki.ssl.a.a("Checking Usage of Certificates");
        if (!OraclePKIX509CertUsage.isCertChainValidFor(x509CertificateArray, 1)) {
            oracle.security.pki.ssl.a.a("Peer is not trusted");
            throw new CertificateException("Peer is not trusted");
        }
        oracle.security.pki.ssl.a.a("Checking Signatures");
        try {
            for (n2 = 0; n2 < oraclePKIX509CertImplArray.length - 1; ++n2) {
                oraclePKIX509CertImplArray[n2].getX509().verifyCertSignature();
            }
        }
        catch (AuthenticationException authenticationException) {
            oracle.security.pki.ssl.a.a("Invalid signature");
            throw new CertificateException(b.getString("PKI-07006"));
        }
        oracle.security.pki.ssl.a.a("Certificate Chain OK");
    }

    public final void b(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.a(x509CertificateArray);
    }

    public final X509Certificate[] a() {
        return this.a.toArray(new X509Certificate[this.a.size()]);
    }
}

