/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.util.Utils;

public class AuthorityInfoAccess
implements Externalizable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, ArrayList<GeneralName>> a = new LinkedHashMap();
    private ASN1Sequence b = null;

    public AuthorityInfoAccess() {
    }

    public AuthorityInfoAccess(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void a(ASN1ObjectID aSN1ObjectID, GeneralName generalName) {
        ArrayList<GeneralName> arrayList = this.a.get(aSN1ObjectID);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(generalName);
        this.a.put(aSN1ObjectID, arrayList);
        this.c();
    }

    public ArrayList<GeneralName> a(ASN1ObjectID aSN1ObjectID) {
        ArrayList<GeneralName> arrayList = this.a.get(aSN1ObjectID);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public boolean b(ASN1ObjectID aSN1ObjectID) {
        return this.a(aSN1ObjectID) != null;
    }

    public int a() {
        return this.a.size();
    }

    public String toString() {
        String string = "AuthorityAccessInfo {";
        for (ASN1ObjectID aSN1ObjectID : this.a.keySet()) {
            ArrayList<GeneralName> arrayList = this.a.get(aSN1ObjectID);
            if (arrayList == null) continue;
            for (GeneralName generalName : arrayList) {
                string = string + " {" + aSN1ObjectID.d() + "," + generalName + "}";
            }
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.c();
        this.a = new LinkedHashMap();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.a()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
            GeneralName generalName = new GeneralName(aSN1SequenceInputStream2);
            this.a(aSN1ObjectID, generalName);
            aSN1SequenceInputStream2.b();
        }
        aSN1SequenceInputStream.b();
        if (this.a.size() == 0) {
            throw new ASN1FormatException("Sequence must contain at least 1 access description");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    @Override
    public int length() {
        return this.b().length();
    }

    private ASN1Sequence b() {
        if (this.b == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            for (ASN1ObjectID aSN1ObjectID : this.a.keySet()) {
                ArrayList<GeneralName> arrayList = this.a.get(aSN1ObjectID);
                if (arrayList == null) continue;
                for (GeneralName generalName : arrayList) {
                    ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                    aSN1Sequence2.a(aSN1ObjectID);
                    aSN1Sequence2.a(generalName);
                    aSN1Sequence.a(aSN1Sequence2);
                }
            }
            this.b = aSN1Sequence;
        }
        return this.b;
    }

    private void c() {
        this.b = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

