/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.net.URL;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLEncoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLSchLocTag;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.schema.SchemaResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import org.xml.sax.SAXException;

class BinXMLSchemaResolver
implements SchemaResolver,
BinXMLConstants {
    BinXMLVocabularyManager vocabManager;
    BinXMLSchema currentBinSchema;
    Stack schlocstack;
    XMLError err;

    BinXMLSchemaResolver(BinXMLVocabularyManager binXMLVocabularyManager) {
        this.vocabManager = binXMLVocabularyManager;
    }

    @Override
    public XMLSchema resolve(String string, QName qName) {
        try {
            Object object;
            URL uRL = null;
            if (string != null) {
                if (this.vocabManager.getMetadataProvider() instanceof DBBinXMLMetadataProviderImpl) {
                    this.currentBinSchema = this.getSchema(string);
                } else {
                    object = XMLUtil.createURL(string);
                    this.currentBinSchema = this.getSchema((URL)object);
                }
            }
            if (this.currentBinSchema == null && qName != null) {
                this.currentBinSchema = this.vocabManager.getBinXMLSchema(qName);
            }
            if (this.currentBinSchema == null && string != null) {
                try {
                    object = this.vocabManager.registerSchema(uRL);
                    this.currentBinSchema = this.vocabManager.getBinXMLSchema((BinXMLVocabId)object);
                }
                catch (BinXMLException binXMLException) {
                    throw new IllegalStateException(binXMLException);
                }
            }
            if (this.currentBinSchema != null) {
                return this.currentBinSchema.getXMLSchema();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return null;
    }

    BinXMLSchema getSchema(URL uRL) {
        if (uRL != null) {
            this.currentBinSchema = this.vocabManager.getBinXMLSchema(uRL);
        }
        if (this.currentBinSchema == null && uRL != null) {
            try {
                BinXMLVocabId binXMLVocabId = this.vocabManager.registerSchema(uRL);
                this.currentBinSchema = this.vocabManager.getBinXMLSchema(binXMLVocabId);
            }
            catch (BinXMLException binXMLException) {
                throw new IllegalStateException(binXMLException);
            }
        }
        return this.currentBinSchema;
    }

    BinXMLSchema getSchema(String string) throws BinXMLException {
        if (string != null) {
            this.currentBinSchema = this.vocabManager.getBinXMLSchema(string, null);
        }
        return this.currentBinSchema;
    }

    BinXMLSchema getCurrentSchema() throws BinXMLException {
        return this.currentBinSchema;
    }

    private String[][] getSchemaStrings(String[] stringArray) {
        int n = stringArray.length;
        String[][] stringArray2 = new String[2][n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray2[0][n2] = stringArray[n3++];
            stringArray2[1][n2++] = stringArray[n3++];
        }
        return stringArray2;
    }

    private BinXMLSchema getBinXMLSchema(boolean bl, String string) throws BinXMLException, XSDException, SAXException {
        String[] stringArray = BinXMLUtil.getTokens(string);
        BinXMLSchema binXMLSchema = null;
        if (!bl) {
            binXMLSchema = stringArray.length == 1 ? this.vocabManager.getBinXMLSchema(string, null) : this.vocabManager.getBinXMLSchema(stringArray, null);
        } else {
            if (stringArray.length % 2 == 1) {
                throw new BinXMLException(this.err.getMessage1(35010, string));
            }
            String[][] stringArray2 = this.getSchemaStrings(stringArray);
            binXMLSchema = this.vocabManager.getBinXMLSchema(stringArray[1], stringArray2[0]);
            if (binXMLSchema == null) {
                return null;
            }
        }
        return binXMLSchema;
    }

    BinXMLSchema getCurrentSchema(String string, boolean bl, BinXMLEncoderImpl binXMLEncoderImpl) throws BinXMLException, XSDException, SAXException {
        BinXMLSchema binXMLSchema = this.getBinXMLSchema(bl, string);
        if (binXMLSchema == null) {
            return null;
        }
        XSDValidator xSDValidator = binXMLEncoderImpl.getValidator();
        xSDValidator.setXMLSchema(binXMLSchema.getXMLSchema());
        this.currentBinSchema.setValidator(xSDValidator);
        return this.currentBinSchema;
    }

    void pushSchLocTag(BinXMLSchLocTag binXMLSchLocTag) {
        if (this.schlocstack == null) {
            this.schlocstack = new Stack();
        }
        this.schlocstack.push(binXMLSchLocTag);
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    XSDValidator popSchLocTag(String string, String string2, String string3, int n, XSDValidator xSDValidator) {
        if (this.schlocstack == null || this.schlocstack.size() == 0) {
            return xSDValidator;
        }
        BinXMLSchLocTag binXMLSchLocTag = (BinXMLSchLocTag)this.schlocstack.peek();
        if (binXMLSchLocTag.getDepth() != n) {
            return xSDValidator;
        }
        if (!binXMLSchLocTag.getQName().equals(string3)) {
            return xSDValidator;
        }
        if (!binXMLSchLocTag.getLocalName().equals(string2)) {
            return xSDValidator;
        }
        if (!binXMLSchLocTag.getNamespaceURI().equals(string)) {
            return xSDValidator;
        }
        return ((BinXMLSchLocTag)this.schlocstack.pop()).getValidator();
    }
}

