/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.okeworkloadidentity.internal;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ServiceAccountTokenSupplier;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AbstractFederationClient;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.okeworkloadidentity.internal.GetOkeResourcePrincipalSessionTokenDetails;
import com.oracle.bmc.auth.okeworkloadidentity.internal.GetOkeResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.okeworkloadidentity.internal.GetOkeResourcePrincipalSessionTokenResponse;
import com.oracle.bmc.auth.okeworkloadidentity.internal.OkeResourcePrincipalSessionToken;
import com.oracle.bmc.auth.okeworkloadidentity.internal.OkeTenancyOnlyAuthenticationDetailsProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.Serializer;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.internal.ClientIdFilter;
import com.oracle.bmc.http.internal.LogHeadersFilter;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkeWorkloadIdentityResourcePrincipalsFederationClient
extends AbstractFederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(OkeWorkloadIdentityResourcePrincipalsFederationClient.class);
    private static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private static final String JWT_FORMAT = "Bearer %s";
    private static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final int PROXYMUX_SERVER_PORT = 12250;
    private final ServiceAccountTokenSupplier serviceAccountTokenSupplier;
    private final OkeTenancyOnlyAuthenticationDetailsProvider provider;

    public OkeWorkloadIdentityResourcePrincipalsFederationClient(SessionKeySupplier sessionKeySupplier, ServiceAccountTokenSupplier serviceAccountTokenSupplier, OkeTenancyOnlyAuthenticationDetailsProvider okeTenancyOnlyAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration, List<ClientConfigurator> additionalClientConfigurators) {
        super(OkeWorkloadIdentityResourcePrincipalsFederationClient.getRptEndpoint(), "", sessionKeySupplier, (BasicAuthenticationDetailsProvider)okeTenancyOnlyAuthenticationDetailsProvider, clientConfigurator, circuitBreakerConfiguration, additionalClientConfigurators);
        this.serviceAccountTokenSupplier = serviceAccountTokenSupplier;
        this.provider = okeTenancyOnlyAuthenticationDetailsProvider;
    }

    public String getSecurityToken() {
        SecurityTokenAdapter securityTokenAdapter = this.getSecurityTokenAdapter();
        try {
            Duration time = Duration.ZERO;
            if (securityTokenAdapter.isValid() && securityTokenAdapter.getTokenValidDuration() != null) {
                time = securityTokenAdapter.getTokenValidDuration().dividedBy(2L);
            }
            return this.refreshAndGetSecurityTokenIfExpiringWithin(time);
        }
        catch (Exception e) {
            LOG.info("Refresh RPST token failed, use cached RPST token.", (Throwable)e);
            return securityTokenAdapter.getSecurityToken();
        }
    }

    private static String getRptEndpoint() {
        String host = System.getenv().get(KUBERNETES_SERVICE_HOST);
        if (host == null) {
            throw new IllegalArgumentException("Invalid environment variable KUBERNETES_SERVICE_HOST, please contact OKE Foundation team for help.");
        }
        return "https://" + host + ":" + 12250;
    }

    protected HttpClient makeClient(String endpoint, RequestSigner requestSigner) {
        if (StringUtils.isBlank((String)endpoint)) {
            return null;
        }
        HttpClientBuilder rptBuilder = HttpProvider.getDefault().newBuilder().baseUri(URI.create(endpoint)).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(requestSigner, Collections.emptyMap())).registerRequestInterceptor(3000, (RequestInterceptor)new ClientIdFilter()).registerRequestInterceptor(5000, (RequestInterceptor)new LogHeadersFilter());
        if (this.clientConfigurator != null) {
            this.clientConfigurator.customizeClient(rptBuilder);
        }
        for (ClientConfigurator additionalConfigurator : this.additionalClientConfigurator) {
            additionalConfigurator.customizeClient(rptBuilder);
        }
        return rptBuilder.build();
    }

    protected SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the proxymux server");
        String token = this.serviceAccountTokenSupplier.getServiceAccountToken();
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Key pair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        String opcRequestId = ClientCall.generateRequestId();
        LOG.debug("Request id for resourcePrincipalSessionTokens request: '{}'", (Object)opcRequestId);
        GetOkeResourcePrincipalSessionTokenDetails getOkeResourcePrincipalSessionTokenDetails = GetOkeResourcePrincipalSessionTokenDetails.builder().podKey(AuthUtils.base64EncodeNoChunking((RSAPublicKey)publicKey)).build();
        GetOkeResourcePrincipalSessionTokenRequest getOkeResourcePrincipalSessionTokenRequest = GetOkeResourcePrincipalSessionTokenRequest.builder().getOkeResourcePrincipalSessionTokenDetails(getOkeResourcePrincipalSessionTokenDetails).build();
        OkeResourcePrincipalSessionToken okeResourcePrincipalSessionToken = ((GetOkeResourcePrincipalSessionTokenResponse)ClientCall.builder((HttpClient)this.resourcePrincipalTokenClient, (BmcRequest)getOkeResourcePrincipalSessionTokenRequest, (Supplier<GetOkeResourcePrincipalSessionTokenResponse.Builder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/oracle/bmc/auth/okeworkloadidentity/internal/GetOkeResourcePrincipalSessionTokenResponse$Builder;)()).logger((Logger)OkeWorkloadIdentityResourcePrincipalsFederationClient.LOG, (String)"OkeWorkloadIdentityResourcePrincipalsTokenClient").serviceDetails((String)"OkeWorkloadIdentity", (String)"resourcePrincipalSessionTokens", (String)"Unknown API reference link").method((Method)Method.POST).requestBuilder((Supplier<BmcRequest.Builder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, builder(), ()Lcom/oracle/bmc/requests/BmcRequest$Builder;)()).appendPathPart((String)"resourcePrincipalSessionTokens").accept((String[])new String[]{"application/json"}).appendHeader((String)AUTHORIZATION_HEADER, (String)String.format((String)JWT_FORMAT, (Object[])new Object[]{token})).appendHeader((String)"opc-request-id", (String)opcRequestId).hasBody().handleBody(OkeResourcePrincipalSessionToken.class, (BiConsumer<GetOkeResourcePrincipalSessionTokenResponse.Builder, OkeResourcePrincipalSessionToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, body(com.oracle.bmc.auth.okeworkloadidentity.internal.OkeResourcePrincipalSessionToken ), (Lcom/oracle/bmc/auth/okeworkloadidentity/internal/GetOkeResourcePrincipalSessionTokenResponse$Builder;Lcom/oracle/bmc/auth/okeworkloadidentity/internal/OkeResourcePrincipalSessionToken;)V)()).clientConfigurator((ClientConfigurator)this.clientConfigurator).circuitBreaker((OciCircuitBreaker)this.circuitBreaker).callSync()).body;
        try {
            String payload = okeResourcePrincipalSessionToken.getToken();
            String jsonString = new String(Base64.getDecoder().decode(payload), "UTF-8");
            Serializer serializer = Serializer.getDefault();
            OkeResourcePrincipalSessionToken decoded = (OkeResourcePrincipalSessionToken)serializer.readValue(jsonString, OkeResourcePrincipalSessionToken.class);
            String jwtToken = decoded.getToken().substring(3);
            return new SecurityTokenAdapter(jwtToken, this.sessionKeySupplier);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("RPST cannot be decoded correctly. Please contact OKE Foundation team for help.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("RPST cannot be parsed correctly. Please contact OKE Foundation team for help.", e);
        }
    }
}

