/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.analytics.AnalyticsAsync;
import com.oracle.bmc.analytics.internal.http.ChangeAnalyticsInstanceCompartmentConverter;
import com.oracle.bmc.analytics.internal.http.ChangeAnalyticsInstanceNetworkEndpointConverter;
import com.oracle.bmc.analytics.internal.http.CreateAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.CreatePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.CreateVanityUrlConverter;
import com.oracle.bmc.analytics.internal.http.DeleteAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.DeletePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.DeleteVanityUrlConverter;
import com.oracle.bmc.analytics.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.analytics.internal.http.GetAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.GetPrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.analytics.internal.http.ListAnalyticsInstancesConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.analytics.internal.http.ScaleAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.StartAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.StopAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.UpdateAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.UpdatePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.UpdateVanityUrlConverter;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceCompartmentRequest;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceNetworkEndpointRequest;
import com.oracle.bmc.analytics.requests.CreateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.CreatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.CreateVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.DeletePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.DeleteVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetPrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.requests.ScaleAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StartAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StopAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.UpdateVanityUrlRequest;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceCompartmentResponse;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceNetworkEndpointResponse;
import com.oracle.bmc.analytics.responses.CreateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.CreatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.CreateVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.DeletePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.DeleteVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetPrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.analytics.responses.ScaleAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StartAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StopAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.UpdateVanityUrlResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsAsyncClient
implements AnalyticsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://analytics.{region}.ocp.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeAnalyticsInstanceCompartmentResponse> changeAnalyticsInstanceCompartment(ChangeAnalyticsInstanceCompartmentRequest request, AsyncHandler<ChangeAnalyticsInstanceCompartmentRequest, ChangeAnalyticsInstanceCompartmentResponse> handler) {
        LOG.trace("Called async changeAnalyticsInstanceCompartment");
        ChangeAnalyticsInstanceCompartmentRequest interceptedRequest = ChangeAnalyticsInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAnalyticsInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAnalyticsInstanceCompartmentResponse> transformer = ChangeAnalyticsInstanceCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeAnalyticsInstanceCompartmentRequest, ChangeAnalyticsInstanceCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeAnalyticsInstanceCompartmentRequest, ChangeAnalyticsInstanceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeAnalyticsInstanceNetworkEndpointResponse> changeAnalyticsInstanceNetworkEndpoint(ChangeAnalyticsInstanceNetworkEndpointRequest request, AsyncHandler<ChangeAnalyticsInstanceNetworkEndpointRequest, ChangeAnalyticsInstanceNetworkEndpointResponse> handler) {
        LOG.trace("Called async changeAnalyticsInstanceNetworkEndpoint");
        ChangeAnalyticsInstanceNetworkEndpointRequest interceptedRequest = ChangeAnalyticsInstanceNetworkEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAnalyticsInstanceNetworkEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAnalyticsInstanceNetworkEndpointResponse> transformer = ChangeAnalyticsInstanceNetworkEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeAnalyticsInstanceNetworkEndpointRequest, ChangeAnalyticsInstanceNetworkEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeAnalyticsInstanceNetworkEndpointRequest, ChangeAnalyticsInstanceNetworkEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAnalyticsInstanceResponse> createAnalyticsInstance(CreateAnalyticsInstanceRequest request, AsyncHandler<CreateAnalyticsInstanceRequest, CreateAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async createAnalyticsInstance");
        CreateAnalyticsInstanceRequest interceptedRequest = CreateAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAnalyticsInstanceResponse> transformer = CreateAnalyticsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAnalyticsInstanceRequest, CreateAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAnalyticsInstanceRequest, CreateAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePrivateAccessChannelResponse> createPrivateAccessChannel(CreatePrivateAccessChannelRequest request, AsyncHandler<CreatePrivateAccessChannelRequest, CreatePrivateAccessChannelResponse> handler) {
        LOG.trace("Called async createPrivateAccessChannel");
        CreatePrivateAccessChannelRequest interceptedRequest = CreatePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePrivateAccessChannelResponse> transformer = CreatePrivateAccessChannelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePrivateAccessChannelRequest, CreatePrivateAccessChannelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePrivateAccessChannelRequest, CreatePrivateAccessChannelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateVanityUrlResponse> createVanityUrl(CreateVanityUrlRequest request, AsyncHandler<CreateVanityUrlRequest, CreateVanityUrlResponse> handler) {
        LOG.trace("Called async createVanityUrl");
        CreateVanityUrlRequest interceptedRequest = CreateVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVanityUrlResponse> transformer = CreateVanityUrlConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateVanityUrlRequest, CreateVanityUrlResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateVanityUrlRequest, CreateVanityUrlResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAnalyticsInstanceResponse> deleteAnalyticsInstance(DeleteAnalyticsInstanceRequest request, AsyncHandler<DeleteAnalyticsInstanceRequest, DeleteAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async deleteAnalyticsInstance");
        DeleteAnalyticsInstanceRequest interceptedRequest = DeleteAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAnalyticsInstanceResponse> transformer = DeleteAnalyticsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteAnalyticsInstanceRequest, DeleteAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAnalyticsInstanceRequest, DeleteAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePrivateAccessChannelResponse> deletePrivateAccessChannel(DeletePrivateAccessChannelRequest request, AsyncHandler<DeletePrivateAccessChannelRequest, DeletePrivateAccessChannelResponse> handler) {
        LOG.trace("Called async deletePrivateAccessChannel");
        DeletePrivateAccessChannelRequest interceptedRequest = DeletePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePrivateAccessChannelResponse> transformer = DeletePrivateAccessChannelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeletePrivateAccessChannelRequest, DeletePrivateAccessChannelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePrivateAccessChannelRequest, DeletePrivateAccessChannelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteVanityUrlResponse> deleteVanityUrl(DeleteVanityUrlRequest request, AsyncHandler<DeleteVanityUrlRequest, DeleteVanityUrlResponse> handler) {
        LOG.trace("Called async deleteVanityUrl");
        DeleteVanityUrlRequest interceptedRequest = DeleteVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVanityUrlResponse> transformer = DeleteVanityUrlConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteVanityUrlRequest, DeleteVanityUrlResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteVanityUrlRequest, DeleteVanityUrlResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        LOG.trace("Called async deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteWorkRequestRequest, DeleteWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAnalyticsInstanceResponse> getAnalyticsInstance(GetAnalyticsInstanceRequest request, AsyncHandler<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async getAnalyticsInstance");
        GetAnalyticsInstanceRequest interceptedRequest = GetAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsInstanceResponse> transformer = GetAnalyticsInstanceConverter.fromResponse();
        AsyncHandler<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPrivateAccessChannelResponse> getPrivateAccessChannel(GetPrivateAccessChannelRequest request, AsyncHandler<GetPrivateAccessChannelRequest, GetPrivateAccessChannelResponse> handler) {
        LOG.trace("Called async getPrivateAccessChannel");
        GetPrivateAccessChannelRequest interceptedRequest = GetPrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPrivateAccessChannelResponse> transformer = GetPrivateAccessChannelConverter.fromResponse();
        AsyncHandler<GetPrivateAccessChannelRequest, GetPrivateAccessChannelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPrivateAccessChannelRequest, GetPrivateAccessChannelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAnalyticsInstancesResponse> listAnalyticsInstances(ListAnalyticsInstancesRequest request, AsyncHandler<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse> handler) {
        LOG.trace("Called async listAnalyticsInstances");
        ListAnalyticsInstancesRequest interceptedRequest = ListAnalyticsInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAnalyticsInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAnalyticsInstancesResponse> transformer = ListAnalyticsInstancesConverter.fromResponse();
        AsyncHandler<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScaleAnalyticsInstanceResponse> scaleAnalyticsInstance(ScaleAnalyticsInstanceRequest request, AsyncHandler<ScaleAnalyticsInstanceRequest, ScaleAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async scaleAnalyticsInstance");
        ScaleAnalyticsInstanceRequest interceptedRequest = ScaleAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScaleAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScaleAnalyticsInstanceResponse> transformer = ScaleAnalyticsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ScaleAnalyticsInstanceRequest, ScaleAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScaleAnalyticsInstanceRequest, ScaleAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartAnalyticsInstanceResponse> startAnalyticsInstance(StartAnalyticsInstanceRequest request, AsyncHandler<StartAnalyticsInstanceRequest, StartAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async startAnalyticsInstance");
        StartAnalyticsInstanceRequest interceptedRequest = StartAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAnalyticsInstanceResponse> transformer = StartAnalyticsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartAnalyticsInstanceRequest, StartAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartAnalyticsInstanceRequest, StartAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopAnalyticsInstanceResponse> stopAnalyticsInstance(StopAnalyticsInstanceRequest request, AsyncHandler<StopAnalyticsInstanceRequest, StopAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async stopAnalyticsInstance");
        StopAnalyticsInstanceRequest interceptedRequest = StopAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAnalyticsInstanceResponse> transformer = StopAnalyticsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopAnalyticsInstanceRequest, StopAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopAnalyticsInstanceRequest, StopAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAnalyticsInstanceResponse> updateAnalyticsInstance(UpdateAnalyticsInstanceRequest request, AsyncHandler<UpdateAnalyticsInstanceRequest, UpdateAnalyticsInstanceResponse> handler) {
        LOG.trace("Called async updateAnalyticsInstance");
        UpdateAnalyticsInstanceRequest interceptedRequest = UpdateAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAnalyticsInstanceResponse> transformer = UpdateAnalyticsInstanceConverter.fromResponse();
        AsyncHandler<UpdateAnalyticsInstanceRequest, UpdateAnalyticsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAnalyticsInstanceRequest, UpdateAnalyticsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePrivateAccessChannelResponse> updatePrivateAccessChannel(UpdatePrivateAccessChannelRequest request, AsyncHandler<UpdatePrivateAccessChannelRequest, UpdatePrivateAccessChannelResponse> handler) {
        LOG.trace("Called async updatePrivateAccessChannel");
        UpdatePrivateAccessChannelRequest interceptedRequest = UpdatePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePrivateAccessChannelResponse> transformer = UpdatePrivateAccessChannelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdatePrivateAccessChannelRequest, UpdatePrivateAccessChannelResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePrivateAccessChannelRequest, UpdatePrivateAccessChannelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateVanityUrlResponse> updateVanityUrl(UpdateVanityUrlRequest request, AsyncHandler<UpdateVanityUrlRequest, UpdateVanityUrlResponse> handler) {
        LOG.trace("Called async updateVanityUrl");
        UpdateVanityUrlRequest interceptedRequest = UpdateVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVanityUrlResponse> transformer = UpdateVanityUrlConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateVanityUrlRequest, UpdateVanityUrlResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateVanityUrlRequest, UpdateVanityUrlResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnalyticsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AnalyticsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AnalyticsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

