/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.analytics.Analytics;
import com.oracle.bmc.analytics.AnalyticsPaginators;
import com.oracle.bmc.analytics.AnalyticsWaiters;
import com.oracle.bmc.analytics.internal.http.ChangeAnalyticsInstanceCompartmentConverter;
import com.oracle.bmc.analytics.internal.http.ChangeAnalyticsInstanceNetworkEndpointConverter;
import com.oracle.bmc.analytics.internal.http.CreateAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.CreatePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.CreateVanityUrlConverter;
import com.oracle.bmc.analytics.internal.http.DeleteAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.DeletePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.DeleteVanityUrlConverter;
import com.oracle.bmc.analytics.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.analytics.internal.http.GetAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.GetPrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.analytics.internal.http.ListAnalyticsInstancesConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.analytics.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.analytics.internal.http.ScaleAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.StartAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.StopAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.UpdateAnalyticsInstanceConverter;
import com.oracle.bmc.analytics.internal.http.UpdatePrivateAccessChannelConverter;
import com.oracle.bmc.analytics.internal.http.UpdateVanityUrlConverter;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceCompartmentRequest;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceNetworkEndpointRequest;
import com.oracle.bmc.analytics.requests.CreateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.CreatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.CreateVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.DeletePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.DeleteVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetPrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.requests.ScaleAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StartAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StopAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.UpdateVanityUrlRequest;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceCompartmentResponse;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceNetworkEndpointResponse;
import com.oracle.bmc.analytics.responses.CreateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.CreatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.CreateVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.DeletePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.DeleteVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetPrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.analytics.responses.ScaleAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StartAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StopAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.UpdateVanityUrlResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsClient
implements Analytics {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://analytics.{region}.ocp.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final AnalyticsWaiters waiters;
    private final AnalyticsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Analytics-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AnalyticsWaiters(executorService, this);
        this.paginators = new AnalyticsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeAnalyticsInstanceCompartmentResponse changeAnalyticsInstanceCompartment(ChangeAnalyticsInstanceCompartmentRequest request) {
        LOG.trace("Called changeAnalyticsInstanceCompartment");
        ChangeAnalyticsInstanceCompartmentRequest interceptedRequest = ChangeAnalyticsInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAnalyticsInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAnalyticsInstanceCompartmentResponse> transformer = ChangeAnalyticsInstanceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeAnalyticsInstanceCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeAnalyticsInstanceCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeAnalyticsInstanceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeAnalyticsInstanceNetworkEndpointResponse changeAnalyticsInstanceNetworkEndpoint(ChangeAnalyticsInstanceNetworkEndpointRequest request) {
        LOG.trace("Called changeAnalyticsInstanceNetworkEndpoint");
        ChangeAnalyticsInstanceNetworkEndpointRequest interceptedRequest = ChangeAnalyticsInstanceNetworkEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAnalyticsInstanceNetworkEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAnalyticsInstanceNetworkEndpointResponse> transformer = ChangeAnalyticsInstanceNetworkEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeAnalyticsInstanceNetworkEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeAnalyticsInstanceNetworkEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeAnalyticsInstanceNetworkEndpointDetails(), (BmcRequest)retriedRequest);
                return (ChangeAnalyticsInstanceNetworkEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAnalyticsInstanceResponse createAnalyticsInstance(CreateAnalyticsInstanceRequest request) {
        LOG.trace("Called createAnalyticsInstance");
        CreateAnalyticsInstanceRequest interceptedRequest = CreateAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAnalyticsInstanceResponse> transformer = CreateAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAnalyticsInstanceDetails(), (BmcRequest)retriedRequest);
                return (CreateAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePrivateAccessChannelResponse createPrivateAccessChannel(CreatePrivateAccessChannelRequest request) {
        LOG.trace("Called createPrivateAccessChannel");
        CreatePrivateAccessChannelRequest interceptedRequest = CreatePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePrivateAccessChannelResponse> transformer = CreatePrivateAccessChannelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePrivateAccessChannelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePrivateAccessChannelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePrivateAccessChannelDetails(), (BmcRequest)retriedRequest);
                return (CreatePrivateAccessChannelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVanityUrlResponse createVanityUrl(CreateVanityUrlRequest request) {
        LOG.trace("Called createVanityUrl");
        CreateVanityUrlRequest interceptedRequest = CreateVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVanityUrlResponse> transformer = CreateVanityUrlConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateVanityUrlResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateVanityUrlResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateVanityUrlDetails(), (BmcRequest)retriedRequest);
                return (CreateVanityUrlResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAnalyticsInstanceResponse deleteAnalyticsInstance(DeleteAnalyticsInstanceRequest request) {
        LOG.trace("Called deleteAnalyticsInstance");
        DeleteAnalyticsInstanceRequest interceptedRequest = DeleteAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAnalyticsInstanceResponse> transformer = DeleteAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePrivateAccessChannelResponse deletePrivateAccessChannel(DeletePrivateAccessChannelRequest request) {
        LOG.trace("Called deletePrivateAccessChannel");
        DeletePrivateAccessChannelRequest interceptedRequest = DeletePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePrivateAccessChannelResponse> transformer = DeletePrivateAccessChannelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeletePrivateAccessChannelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePrivateAccessChannelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePrivateAccessChannelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVanityUrlResponse deleteVanityUrl(DeleteVanityUrlRequest request) {
        LOG.trace("Called deleteVanityUrl");
        DeleteVanityUrlRequest interceptedRequest = DeleteVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVanityUrlResponse> transformer = DeleteVanityUrlConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteVanityUrlResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteVanityUrlResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteVanityUrlResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        LOG.trace("Called deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAnalyticsInstanceResponse getAnalyticsInstance(GetAnalyticsInstanceRequest request) {
        LOG.trace("Called getAnalyticsInstance");
        GetAnalyticsInstanceRequest interceptedRequest = GetAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsInstanceResponse> transformer = GetAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPrivateAccessChannelResponse getPrivateAccessChannel(GetPrivateAccessChannelRequest request) {
        LOG.trace("Called getPrivateAccessChannel");
        GetPrivateAccessChannelRequest interceptedRequest = GetPrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPrivateAccessChannelResponse> transformer = GetPrivateAccessChannelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPrivateAccessChannelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPrivateAccessChannelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPrivateAccessChannelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAnalyticsInstancesResponse listAnalyticsInstances(ListAnalyticsInstancesRequest request) {
        LOG.trace("Called listAnalyticsInstances");
        ListAnalyticsInstancesRequest interceptedRequest = ListAnalyticsInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAnalyticsInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAnalyticsInstancesResponse> transformer = ListAnalyticsInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAnalyticsInstancesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAnalyticsInstancesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAnalyticsInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ScaleAnalyticsInstanceResponse scaleAnalyticsInstance(ScaleAnalyticsInstanceRequest request) {
        LOG.trace("Called scaleAnalyticsInstance");
        ScaleAnalyticsInstanceRequest interceptedRequest = ScaleAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScaleAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScaleAnalyticsInstanceResponse> transformer = ScaleAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ScaleAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ScaleAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getScaleAnalyticsInstanceDetails(), (BmcRequest)retriedRequest);
                return (ScaleAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartAnalyticsInstanceResponse startAnalyticsInstance(StartAnalyticsInstanceRequest request) {
        LOG.trace("Called startAnalyticsInstance");
        StartAnalyticsInstanceRequest interceptedRequest = StartAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAnalyticsInstanceResponse> transformer = StartAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopAnalyticsInstanceResponse stopAnalyticsInstance(StopAnalyticsInstanceRequest request) {
        LOG.trace("Called stopAnalyticsInstance");
        StopAnalyticsInstanceRequest interceptedRequest = StopAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAnalyticsInstanceResponse> transformer = StopAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StopAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAnalyticsInstanceResponse updateAnalyticsInstance(UpdateAnalyticsInstanceRequest request) {
        LOG.trace("Called updateAnalyticsInstance");
        UpdateAnalyticsInstanceRequest interceptedRequest = UpdateAnalyticsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAnalyticsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAnalyticsInstanceResponse> transformer = UpdateAnalyticsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAnalyticsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAnalyticsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAnalyticsInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateAnalyticsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePrivateAccessChannelResponse updatePrivateAccessChannel(UpdatePrivateAccessChannelRequest request) {
        LOG.trace("Called updatePrivateAccessChannel");
        UpdatePrivateAccessChannelRequest interceptedRequest = UpdatePrivateAccessChannelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePrivateAccessChannelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePrivateAccessChannelResponse> transformer = UpdatePrivateAccessChannelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdatePrivateAccessChannelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePrivateAccessChannelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePrivateAccessChannelDetails(), (BmcRequest)retriedRequest);
                return (UpdatePrivateAccessChannelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVanityUrlResponse updateVanityUrl(UpdateVanityUrlRequest request) {
        LOG.trace("Called updateVanityUrl");
        UpdateVanityUrlRequest interceptedRequest = UpdateVanityUrlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVanityUrlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVanityUrlResponse> transformer = UpdateVanityUrlConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateVanityUrlResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateVanityUrlResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateVanityUrlDetails(), (BmcRequest)retriedRequest);
                return (UpdateVanityUrlResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AnalyticsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AnalyticsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnalyticsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AnalyticsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AnalyticsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

