/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.analytics.Analytics;
import com.oracle.bmc.analytics.model.AnalyticsInstanceLifecycleState;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class AnalyticsWaiters {
    private final ExecutorService executorService;
    private final Analytics client;

    public Waiter<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> forAnalyticsInstance(GetAnalyticsInstanceRequest request, AnalyticsInstanceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAnalyticsInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> forAnalyticsInstance(GetAnalyticsInstanceRequest request, AnalyticsInstanceLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAnalyticsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> forAnalyticsInstance(GetAnalyticsInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AnalyticsInstanceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAnalyticsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> forAnalyticsInstance(BmcGenericWaiter waiter, GetAnalyticsInstanceRequest request, AnalyticsInstanceLifecycleState ... targetStates) {
        final HashSet<AnalyticsInstanceLifecycleState> targetStatesSet = new HashSet<AnalyticsInstanceLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse>(){

            public GetAnalyticsInstanceResponse apply(GetAnalyticsInstanceRequest request) {
                return AnalyticsWaiters.this.client.getAnalyticsInstance(request);
            }
        }, (Predicate)new Predicate<GetAnalyticsInstanceResponse>(){

            public boolean apply(GetAnalyticsInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getAnalyticsInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AnalyticsInstanceLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return AnalyticsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public AnalyticsWaiters(ExecutorService executorService, Analytics client) {
        this.executorService = executorService;
        this.client = client;
    }
}

