/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FeatureSet {
    SelfServiceAnalytics("SELF_SERVICE_ANALYTICS"),
    EnterpriseAnalytics("ENTERPRISE_ANALYTICS"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, FeatureSet> map;

    private FeatureSet(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static FeatureSet create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'FeatureSet', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(FeatureSet.class);
        map = new HashMap<String, FeatureSet>();
        for (FeatureSet v : FeatureSet.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

