/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPrivateAccessChannelRequest
extends BmcRequest<Void> {
    private String privateAccessChannelKey;
    private String analyticsInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"privateAccessChannelKey", "analyticsInstanceId", "opcRequestId"})
    GetPrivateAccessChannelRequest(String privateAccessChannelKey, String analyticsInstanceId, String opcRequestId) {
        this.privateAccessChannelKey = privateAccessChannelKey;
        this.analyticsInstanceId = analyticsInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrivateAccessChannelKey() {
        return this.privateAccessChannelKey;
    }

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPrivateAccessChannelRequest, Void> {
        private String privateAccessChannelKey;
        private String analyticsInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateAccessChannelRequest o) {
            this.privateAccessChannelKey(o.getPrivateAccessChannelKey());
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateAccessChannelRequest build() {
            GetPrivateAccessChannelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder privateAccessChannelKey(String privateAccessChannelKey) {
            this.privateAccessChannelKey = privateAccessChannelKey;
            return this;
        }

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPrivateAccessChannelRequest buildWithoutInvocationCallback() {
            return new GetPrivateAccessChannelRequest(this.privateAccessChannelKey, this.analyticsInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetPrivateAccessChannelRequest.Builder(privateAccessChannelKey=" + this.privateAccessChannelKey + ", analyticsInstanceId=" + this.analyticsInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

