/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.analytics.model.AnalyticsInstanceLifecycleState;
import com.oracle.bmc.analytics.model.CapacityType;
import com.oracle.bmc.analytics.model.FeatureSet;
import com.oracle.bmc.analytics.model.SortBy;
import com.oracle.bmc.analytics.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListAnalyticsInstancesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String name;
    private CapacityType capacityType;
    private FeatureSet featureSet;
    private AnalyticsInstanceLifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "name", "capacityType", "featureSet", "lifecycleState", "limit", "page", "sortBy", "sortOrder"})
    ListAnalyticsInstancesRequest(String compartmentId, String opcRequestId, String name, CapacityType capacityType, FeatureSet featureSet, AnalyticsInstanceLifecycleState lifecycleState, Integer limit, String page, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.name = name;
        this.capacityType = capacityType;
        this.featureSet = featureSet;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getName() {
        return this.name;
    }

    public CapacityType getCapacityType() {
        return this.capacityType;
    }

    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public AnalyticsInstanceLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAnalyticsInstancesRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private String name;
        private CapacityType capacityType;
        private FeatureSet featureSet;
        private AnalyticsInstanceLifecycleState lifecycleState;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAnalyticsInstancesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.name(o.getName());
            this.capacityType(o.getCapacityType());
            this.featureSet(o.getFeatureSet());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAnalyticsInstancesRequest build() {
            ListAnalyticsInstancesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder capacityType(CapacityType capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        public Builder featureSet(FeatureSet featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        public Builder lifecycleState(AnalyticsInstanceLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListAnalyticsInstancesRequest buildWithoutInvocationCallback() {
            return new ListAnalyticsInstancesRequest(this.compartmentId, this.opcRequestId, this.name, this.capacityType, this.featureSet, this.lifecycleState, this.limit, this.page, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListAnalyticsInstancesRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", name=" + this.name + ", capacityType=" + (Object)((Object)this.capacityType) + ", featureSet=" + (Object)((Object)this.featureSet) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }
}

