/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.announcementsservice.Announcement;
import com.oracle.bmc.announcementsservice.model.AnnouncementSummary;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsRequest;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class AnnouncementPaginators {
    private final Announcement client;

    public Iterable<ListAnnouncementsResponse> listAnnouncementsResponseIterator(final ListAnnouncementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnnouncementsRequest.Builder>(){

            public ListAnnouncementsRequest.Builder get() {
                return ListAnnouncementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, String>(){

            public String apply(ListAnnouncementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementsRequest.Builder>, ListAnnouncementsRequest>(){

            public ListAnnouncementsRequest apply(RequestBuilderAndToken<ListAnnouncementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAnnouncementsRequest, ListAnnouncementsResponse>(){

            public ListAnnouncementsResponse apply(ListAnnouncementsRequest request) {
                return AnnouncementPaginators.this.client.listAnnouncements(request);
            }
        });
    }

    public Iterable<AnnouncementSummary> listAnnouncementsRecordIterator(final ListAnnouncementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnnouncementsRequest.Builder>(){

            public ListAnnouncementsRequest.Builder get() {
                return ListAnnouncementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, String>(){

            public String apply(ListAnnouncementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementsRequest.Builder>, ListAnnouncementsRequest>(){

            public ListAnnouncementsRequest apply(RequestBuilderAndToken<ListAnnouncementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAnnouncementsRequest, ListAnnouncementsResponse>(){

            public ListAnnouncementsResponse apply(ListAnnouncementsRequest request) {
                return AnnouncementPaginators.this.client.listAnnouncements(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, List<AnnouncementSummary>>(){

            public List<AnnouncementSummary> apply(ListAnnouncementsResponse response) {
                return response.getAnnouncementsCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public AnnouncementPaginators(Announcement client) {
        this.client = client;
    }
}

