/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAnnouncementRequest
extends BmcRequest<Void> {
    private String announcementId;
    private String opcRequestId;

    @ConstructorProperties(value={"announcementId", "opcRequestId"})
    GetAnnouncementRequest(String announcementId, String opcRequestId) {
        this.announcementId = announcementId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAnnouncementId() {
        return this.announcementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAnnouncementRequest, Void> {
        private String announcementId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAnnouncementRequest o) {
            this.announcementId(o.getAnnouncementId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAnnouncementRequest build() {
            GetAnnouncementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder announcementId(String announcementId) {
            this.announcementId = announcementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAnnouncementRequest buildWithoutInvocationCallback() {
            return new GetAnnouncementRequest(this.announcementId, this.opcRequestId);
        }

        public String toString() {
            return "GetAnnouncementRequest.Builder(announcementId=" + this.announcementId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

