/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAnnouncementsPreferenceRequest
extends BmcRequest<Void> {
    private String preferenceId;
    private String opcRequestId;

    @ConstructorProperties(value={"preferenceId", "opcRequestId"})
    GetAnnouncementsPreferenceRequest(String preferenceId, String opcRequestId) {
        this.preferenceId = preferenceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPreferenceId() {
        return this.preferenceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAnnouncementsPreferenceRequest, Void> {
        private String preferenceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAnnouncementsPreferenceRequest o) {
            this.preferenceId(o.getPreferenceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAnnouncementsPreferenceRequest build() {
            GetAnnouncementsPreferenceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder preferenceId(String preferenceId) {
            this.preferenceId = preferenceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAnnouncementsPreferenceRequest buildWithoutInvocationCallback() {
            return new GetAnnouncementsPreferenceRequest(this.preferenceId, this.opcRequestId);
        }

        public String toString() {
            return "GetAnnouncementsPreferenceRequest.Builder(preferenceId=" + this.preferenceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

