/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAnnouncementsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String announcementType;
    private LifecycleState lifecycleState;
    private Boolean isBanner;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Date timeOneEarliestTime;
    private Date timeOneLatestTime;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "announcementType", "lifecycleState", "isBanner", "sortBy", "sortOrder", "timeOneEarliestTime", "timeOneLatestTime", "opcRequestId"})
    ListAnnouncementsRequest(String compartmentId, Integer limit, String page, String announcementType, LifecycleState lifecycleState, Boolean isBanner, SortBy sortBy, SortOrder sortOrder, Date timeOneEarliestTime, Date timeOneLatestTime, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.announcementType = announcementType;
        this.lifecycleState = lifecycleState;
        this.isBanner = isBanner;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.timeOneEarliestTime = timeOneEarliestTime;
        this.timeOneLatestTime = timeOneLatestTime;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getAnnouncementType() {
        return this.announcementType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsBanner() {
        return this.isBanner;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Date getTimeOneEarliestTime() {
        return this.timeOneEarliestTime;
    }

    public Date getTimeOneLatestTime() {
        return this.timeOneLatestTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAnnouncementsRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String announcementType;
        private LifecycleState lifecycleState;
        private Boolean isBanner;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Date timeOneEarliestTime;
        private Date timeOneLatestTime;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAnnouncementsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.announcementType(o.getAnnouncementType());
            this.lifecycleState(o.getLifecycleState());
            this.isBanner(o.getIsBanner());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.timeOneEarliestTime(o.getTimeOneEarliestTime());
            this.timeOneLatestTime(o.getTimeOneLatestTime());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAnnouncementsRequest build() {
            ListAnnouncementsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder announcementType(String announcementType) {
            this.announcementType = announcementType;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder isBanner(Boolean isBanner) {
            this.isBanner = isBanner;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder timeOneEarliestTime(Date timeOneEarliestTime) {
            this.timeOneEarliestTime = timeOneEarliestTime;
            return this;
        }

        public Builder timeOneLatestTime(Date timeOneLatestTime) {
            this.timeOneLatestTime = timeOneLatestTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListAnnouncementsRequest buildWithoutInvocationCallback() {
            return new ListAnnouncementsRequest(this.compartmentId, this.limit, this.page, this.announcementType, this.lifecycleState, this.isBanner, this.sortBy, this.sortOrder, this.timeOneEarliestTime, this.timeOneLatestTime, this.opcRequestId);
        }

        public String toString() {
            return "ListAnnouncementsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", announcementType=" + this.announcementType + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", isBanner=" + this.isBanner + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", timeOneEarliestTime=" + this.timeOneEarliestTime + ", timeOneLatestTime=" + this.timeOneLatestTime + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeOneValue("timeOneValue"),
        TimeTwoValue("timeTwoValue"),
        TimeCreated("timeCreated"),
        ReferenceTicketNumber("referenceTicketNumber"),
        Summary("summary"),
        AnnouncementType("announcementType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Active("ACTIVE"),
        Inactive("INACTIVE");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

