/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmcontrolplane.ApmDomain;
import com.oracle.bmc.apmcontrolplane.ApmDomainPaginators;
import com.oracle.bmc.apmcontrolplane.ApmDomainWaiters;
import com.oracle.bmc.apmcontrolplane.internal.http.ChangeApmDomainCompartmentConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.CreateApmDomainConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.DeleteApmDomainConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.GenerateDataKeysConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.GetApmDomainConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListApmDomainWorkRequestsConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListApmDomainsConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListDataKeysConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.RemoveDataKeysConverter;
import com.oracle.bmc.apmcontrolplane.internal.http.UpdateApmDomainConverter;
import com.oracle.bmc.apmcontrolplane.requests.ChangeApmDomainCompartmentRequest;
import com.oracle.bmc.apmcontrolplane.requests.CreateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.DeleteApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GenerateDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.RemoveDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.UpdateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.responses.ChangeApmDomainCompartmentResponse;
import com.oracle.bmc.apmcontrolplane.responses.CreateApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.DeleteApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GenerateDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.RemoveDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.UpdateApmDomainResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmDomainClient
implements ApmDomain {
    private static final Logger LOG = LoggerFactory.getLogger(ApmDomainClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMDOMAIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-cp.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ApmDomainWaiters waiters;
    private final ApmDomainPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApmDomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ApmDomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ApmDomain-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApmDomainWaiters(executorService, this);
        this.paginators = new ApmDomainPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeApmDomainCompartmentResponse changeApmDomainCompartment(ChangeApmDomainCompartmentRequest request) {
        LOG.trace("Called changeApmDomainCompartment");
        ChangeApmDomainCompartmentRequest interceptedRequest = ChangeApmDomainCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApmDomainCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApmDomainCompartmentResponse> transformer = ChangeApmDomainCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeApmDomainCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeApmDomainCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeApmDomainCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeApmDomainCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateApmDomainResponse createApmDomain(CreateApmDomainRequest request) {
        LOG.trace("Called createApmDomain");
        CreateApmDomainRequest interceptedRequest = CreateApmDomainConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApmDomainConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApmDomainResponse> transformer = CreateApmDomainConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateApmDomainResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateApmDomainResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateApmDomainDetails(), (BmcRequest)retriedRequest);
                return (CreateApmDomainResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApmDomainResponse deleteApmDomain(DeleteApmDomainRequest request) {
        LOG.trace("Called deleteApmDomain");
        DeleteApmDomainRequest interceptedRequest = DeleteApmDomainConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApmDomainConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApmDomainResponse> transformer = DeleteApmDomainConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteApmDomainResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteApmDomainResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteApmDomainResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateDataKeysResponse generateDataKeys(GenerateDataKeysRequest request) {
        LOG.trace("Called generateDataKeys");
        GenerateDataKeysRequest interceptedRequest = GenerateDataKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateDataKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateDataKeysResponse> transformer = GenerateDataKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GenerateDataKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GenerateDataKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGenerateDataKeysListDetails(), (BmcRequest)retriedRequest);
                return (GenerateDataKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApmDomainResponse getApmDomain(GetApmDomainRequest request) {
        LOG.trace("Called getApmDomain");
        GetApmDomainRequest interceptedRequest = GetApmDomainConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApmDomainConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApmDomainResponse> transformer = GetApmDomainConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApmDomainResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApmDomainResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApmDomainResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApmDomainWorkRequestsResponse listApmDomainWorkRequests(ListApmDomainWorkRequestsRequest request) {
        LOG.trace("Called listApmDomainWorkRequests");
        ListApmDomainWorkRequestsRequest interceptedRequest = ListApmDomainWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApmDomainWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApmDomainWorkRequestsResponse> transformer = ListApmDomainWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApmDomainWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApmDomainWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApmDomainWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApmDomainsResponse listApmDomains(ListApmDomainsRequest request) {
        LOG.trace("Called listApmDomains");
        ListApmDomainsRequest interceptedRequest = ListApmDomainsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApmDomainsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApmDomainsResponse> transformer = ListApmDomainsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApmDomainsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApmDomainsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApmDomainsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataKeysResponse listDataKeys(ListDataKeysRequest request) {
        LOG.trace("Called listDataKeys");
        ListDataKeysRequest interceptedRequest = ListDataKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataKeysResponse> transformer = ListDataKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveDataKeysResponse removeDataKeys(RemoveDataKeysRequest request) {
        LOG.trace("Called removeDataKeys");
        RemoveDataKeysRequest interceptedRequest = RemoveDataKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveDataKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveDataKeysResponse> transformer = RemoveDataKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RemoveDataKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveDataKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRemoveDataKeysListDetails(), (BmcRequest)retriedRequest);
                return (RemoveDataKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateApmDomainResponse updateApmDomain(UpdateApmDomainRequest request) {
        LOG.trace("Called updateApmDomain");
        UpdateApmDomainRequest interceptedRequest = UpdateApmDomainConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApmDomainConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApmDomainResponse> transformer = UpdateApmDomainConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateApmDomainResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateApmDomainResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateApmDomainDetails(), (BmcRequest)retriedRequest);
                return (UpdateApmDomainResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ApmDomainWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApmDomainPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmDomainClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApmDomainClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApmDomainClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

