/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apmcontrolplane.ApmDomain;
import com.oracle.bmc.apmcontrolplane.model.ApmDomainSummary;
import com.oracle.bmc.apmcontrolplane.model.WorkRequest;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestError;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestLogEntry;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ApmDomainPaginators {
    private final ApmDomain client;

    public Iterable<ListApmDomainsResponse> listApmDomainsResponseIterator(final ListApmDomainsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApmDomainsRequest.Builder>(){

            public ListApmDomainsRequest.Builder get() {
                return ListApmDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApmDomainsResponse, String>(){

            public String apply(ListApmDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApmDomainsRequest.Builder>, ListApmDomainsRequest>(){

            public ListApmDomainsRequest apply(RequestBuilderAndToken<ListApmDomainsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApmDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApmDomainsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApmDomainsRequest, ListApmDomainsResponse>(){

            public ListApmDomainsResponse apply(ListApmDomainsRequest request) {
                return ApmDomainPaginators.this.client.listApmDomains(request);
            }
        });
    }

    public Iterable<ApmDomainSummary> listApmDomainsRecordIterator(final ListApmDomainsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApmDomainsRequest.Builder>(){

            public ListApmDomainsRequest.Builder get() {
                return ListApmDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApmDomainsResponse, String>(){

            public String apply(ListApmDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApmDomainsRequest.Builder>, ListApmDomainsRequest>(){

            public ListApmDomainsRequest apply(RequestBuilderAndToken<ListApmDomainsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApmDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApmDomainsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApmDomainsRequest, ListApmDomainsResponse>(){

            public ListApmDomainsResponse apply(ListApmDomainsRequest request) {
                return ApmDomainPaginators.this.client.listApmDomains(request);
            }
        }, (Function)new Function<ListApmDomainsResponse, List<ApmDomainSummary>>(){

            public List<ApmDomainSummary> apply(ListApmDomainsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApmDomainPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ApmDomainPaginators(ApmDomain client) {
        this.client = client;
    }
}

