/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane.requests;

import com.oracle.bmc.apmcontrolplane.model.DataKeyTypes;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDataKeysRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private DataKeyTypes dataKeyType;
    private String opcRequestId;

    @ConstructorProperties(value={"apmDomainId", "dataKeyType", "opcRequestId"})
    ListDataKeysRequest(String apmDomainId, DataKeyTypes dataKeyType, String opcRequestId) {
        this.apmDomainId = apmDomainId;
        this.dataKeyType = dataKeyType;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public DataKeyTypes getDataKeyType() {
        return this.dataKeyType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataKeysRequest, Void> {
        private String apmDomainId;
        private DataKeyTypes dataKeyType;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataKeysRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.dataKeyType(o.getDataKeyType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataKeysRequest build() {
            ListDataKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder dataKeyType(DataKeyTypes dataKeyType) {
            this.dataKeyType = dataKeyType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListDataKeysRequest buildWithoutInvocationCallback() {
            return new ListDataKeysRequest(this.apmDomainId, this.dataKeyType, this.opcRequestId);
        }

        public String toString() {
            return "ListDataKeysRequest.Builder(apmDomainId=" + this.apmDomainId + ", dataKeyType=" + (Object)((Object)this.dataKeyType) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

