/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmsynthetics.ApmSyntheticAsync;
import com.oracle.bmc.apmsynthetics.internal.http.CreateMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.CreateScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.DeleteMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.DeleteScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetMonitorResultConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListMonitorsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListPublicVantagePointsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListScriptsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.UpdateMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.UpdateScriptConverter;
import com.oracle.bmc.apmsynthetics.requests.CreateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.CreateScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorResultRequest;
import com.oracle.bmc.apmsynthetics.requests.GetScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.ListMonitorsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListPublicVantagePointsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListScriptsRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateScriptRequest;
import com.oracle.bmc.apmsynthetics.responses.CreateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.CreateScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResultResponse;
import com.oracle.bmc.apmsynthetics.responses.GetScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.ListMonitorsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListPublicVantagePointsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListScriptsResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateScriptResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmSyntheticAsyncClient
implements ApmSyntheticAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ApmSyntheticAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMSYNTHETIC").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-synthetic.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateMonitorResponse> createMonitor(CreateMonitorRequest request, AsyncHandler<CreateMonitorRequest, CreateMonitorResponse> handler) {
        LOG.trace("Called async createMonitor");
        CreateMonitorRequest interceptedRequest = CreateMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMonitorResponse> transformer = CreateMonitorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateMonitorRequest, CreateMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateMonitorRequest, CreateMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateScriptResponse> createScript(CreateScriptRequest request, AsyncHandler<CreateScriptRequest, CreateScriptResponse> handler) {
        LOG.trace("Called async createScript");
        CreateScriptRequest interceptedRequest = CreateScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateScriptResponse> transformer = CreateScriptConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateScriptRequest, CreateScriptResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateScriptRequest, CreateScriptResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest request, AsyncHandler<DeleteMonitorRequest, DeleteMonitorResponse> handler) {
        LOG.trace("Called async deleteMonitor");
        DeleteMonitorRequest interceptedRequest = DeleteMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMonitorResponse> transformer = DeleteMonitorConverter.fromResponse();
        AsyncHandler<DeleteMonitorRequest, DeleteMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteMonitorRequest, DeleteMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteScriptResponse> deleteScript(DeleteScriptRequest request, AsyncHandler<DeleteScriptRequest, DeleteScriptResponse> handler) {
        LOG.trace("Called async deleteScript");
        DeleteScriptRequest interceptedRequest = DeleteScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteScriptResponse> transformer = DeleteScriptConverter.fromResponse();
        AsyncHandler<DeleteScriptRequest, DeleteScriptResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteScriptRequest, DeleteScriptResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMonitorResponse> getMonitor(GetMonitorRequest request, AsyncHandler<GetMonitorRequest, GetMonitorResponse> handler) {
        LOG.trace("Called async getMonitor");
        GetMonitorRequest interceptedRequest = GetMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMonitorResponse> transformer = GetMonitorConverter.fromResponse();
        AsyncHandler<GetMonitorRequest, GetMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMonitorRequest, GetMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMonitorResultResponse> getMonitorResult(GetMonitorResultRequest request, AsyncHandler<GetMonitorResultRequest, GetMonitorResultResponse> handler) {
        LOG.trace("Called async getMonitorResult");
        GetMonitorResultRequest interceptedRequest = GetMonitorResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMonitorResultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMonitorResultResponse> transformer = GetMonitorResultConverter.fromResponse();
        AsyncHandler<GetMonitorResultRequest, GetMonitorResultResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMonitorResultRequest, GetMonitorResultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetScriptResponse> getScript(GetScriptRequest request, AsyncHandler<GetScriptRequest, GetScriptResponse> handler) {
        LOG.trace("Called async getScript");
        GetScriptRequest interceptedRequest = GetScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetScriptResponse> transformer = GetScriptConverter.fromResponse();
        AsyncHandler<GetScriptRequest, GetScriptResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetScriptRequest, GetScriptResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMonitorsResponse> listMonitors(ListMonitorsRequest request, AsyncHandler<ListMonitorsRequest, ListMonitorsResponse> handler) {
        LOG.trace("Called async listMonitors");
        ListMonitorsRequest interceptedRequest = ListMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMonitorsResponse> transformer = ListMonitorsConverter.fromResponse();
        AsyncHandler<ListMonitorsRequest, ListMonitorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMonitorsRequest, ListMonitorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPublicVantagePointsResponse> listPublicVantagePoints(ListPublicVantagePointsRequest request, AsyncHandler<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse> handler) {
        LOG.trace("Called async listPublicVantagePoints");
        ListPublicVantagePointsRequest interceptedRequest = ListPublicVantagePointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicVantagePointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicVantagePointsResponse> transformer = ListPublicVantagePointsConverter.fromResponse();
        AsyncHandler<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListScriptsResponse> listScripts(ListScriptsRequest request, AsyncHandler<ListScriptsRequest, ListScriptsResponse> handler) {
        LOG.trace("Called async listScripts");
        ListScriptsRequest interceptedRequest = ListScriptsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScriptsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListScriptsResponse> transformer = ListScriptsConverter.fromResponse();
        AsyncHandler<ListScriptsRequest, ListScriptsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListScriptsRequest, ListScriptsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest request, AsyncHandler<UpdateMonitorRequest, UpdateMonitorResponse> handler) {
        LOG.trace("Called async updateMonitor");
        UpdateMonitorRequest interceptedRequest = UpdateMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMonitorResponse> transformer = UpdateMonitorConverter.fromResponse();
        AsyncHandler<UpdateMonitorRequest, UpdateMonitorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateMonitorRequest, UpdateMonitorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateScriptResponse> updateScript(UpdateScriptRequest request, AsyncHandler<UpdateScriptRequest, UpdateScriptResponse> handler) {
        LOG.trace("Called async updateScript");
        UpdateScriptRequest interceptedRequest = UpdateScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateScriptResponse> transformer = UpdateScriptConverter.fromResponse();
        AsyncHandler<UpdateScriptRequest, UpdateScriptResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateScriptRequest, UpdateScriptResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmSyntheticAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApmSyntheticAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApmSyntheticAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

