/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmsynthetics.ApmSynthetic;
import com.oracle.bmc.apmsynthetics.ApmSyntheticPaginators;
import com.oracle.bmc.apmsynthetics.internal.http.CreateMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.CreateScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.DeleteMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.DeleteScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetMonitorResultConverter;
import com.oracle.bmc.apmsynthetics.internal.http.GetScriptConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListMonitorsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListPublicVantagePointsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.ListScriptsConverter;
import com.oracle.bmc.apmsynthetics.internal.http.UpdateMonitorConverter;
import com.oracle.bmc.apmsynthetics.internal.http.UpdateScriptConverter;
import com.oracle.bmc.apmsynthetics.requests.CreateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.CreateScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorResultRequest;
import com.oracle.bmc.apmsynthetics.requests.GetScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.ListMonitorsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListPublicVantagePointsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListScriptsRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateScriptRequest;
import com.oracle.bmc.apmsynthetics.responses.CreateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.CreateScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResultResponse;
import com.oracle.bmc.apmsynthetics.responses.GetScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.ListMonitorsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListPublicVantagePointsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListScriptsResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateScriptResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmSyntheticClient
implements ApmSynthetic {
    private static final Logger LOG = LoggerFactory.getLogger(ApmSyntheticClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMSYNTHETIC").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-synthetic.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ApmSyntheticPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ApmSyntheticClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApmSyntheticClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApmSyntheticClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApmSyntheticClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApmSyntheticClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApmSyntheticClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApmSyntheticClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected ApmSyntheticClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new ApmSyntheticPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CreateMonitorResponse createMonitor(CreateMonitorRequest request) {
        LOG.trace("Called createMonitor");
        CreateMonitorRequest interceptedRequest = CreateMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMonitorResponse> transformer = CreateMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateMonitorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateMonitorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateMonitorDetails(), (BmcRequest)retriedRequest);
                return (CreateMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateScriptResponse createScript(CreateScriptRequest request) {
        LOG.trace("Called createScript");
        CreateScriptRequest interceptedRequest = CreateScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateScriptResponse> transformer = CreateScriptConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateScriptResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateScriptResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateScriptDetails(), (BmcRequest)retriedRequest);
                return (CreateScriptResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest request) {
        LOG.trace("Called deleteMonitor");
        DeleteMonitorRequest interceptedRequest = DeleteMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMonitorResponse> transformer = DeleteMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteMonitorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteMonitorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteScriptResponse deleteScript(DeleteScriptRequest request) {
        LOG.trace("Called deleteScript");
        DeleteScriptRequest interceptedRequest = DeleteScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteScriptResponse> transformer = DeleteScriptConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteScriptResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteScriptResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteScriptResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMonitorResponse getMonitor(GetMonitorRequest request) {
        LOG.trace("Called getMonitor");
        GetMonitorRequest interceptedRequest = GetMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMonitorResponse> transformer = GetMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetMonitorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMonitorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMonitorResultResponse getMonitorResult(GetMonitorResultRequest request) {
        LOG.trace("Called getMonitorResult");
        GetMonitorResultRequest interceptedRequest = GetMonitorResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMonitorResultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMonitorResultResponse> transformer = GetMonitorResultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetMonitorResultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMonitorResultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMonitorResultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetScriptResponse getScript(GetScriptRequest request) {
        LOG.trace("Called getScript");
        GetScriptRequest interceptedRequest = GetScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetScriptResponse> transformer = GetScriptConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetScriptResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetScriptResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetScriptResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMonitorsResponse listMonitors(ListMonitorsRequest request) {
        LOG.trace("Called listMonitors");
        ListMonitorsRequest interceptedRequest = ListMonitorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMonitorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMonitorsResponse> transformer = ListMonitorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListMonitorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMonitorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMonitorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublicVantagePointsResponse listPublicVantagePoints(ListPublicVantagePointsRequest request) {
        LOG.trace("Called listPublicVantagePoints");
        ListPublicVantagePointsRequest interceptedRequest = ListPublicVantagePointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicVantagePointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicVantagePointsResponse> transformer = ListPublicVantagePointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPublicVantagePointsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPublicVantagePointsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPublicVantagePointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListScriptsResponse listScripts(ListScriptsRequest request) {
        LOG.trace("Called listScripts");
        ListScriptsRequest interceptedRequest = ListScriptsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScriptsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListScriptsResponse> transformer = ListScriptsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListScriptsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListScriptsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListScriptsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateMonitorResponse updateMonitor(UpdateMonitorRequest request) {
        LOG.trace("Called updateMonitor");
        UpdateMonitorRequest interceptedRequest = UpdateMonitorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMonitorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMonitorResponse> transformer = UpdateMonitorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateMonitorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateMonitorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateMonitorDetails(), (BmcRequest)retriedRequest);
                return (UpdateMonitorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateScriptResponse updateScript(UpdateScriptRequest request) {
        LOG.trace("Called updateScript");
        UpdateScriptRequest interceptedRequest = UpdateScriptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScriptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateScriptResponse> transformer = UpdateScriptConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateScriptResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateScriptResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateScriptDetails(), (BmcRequest)retriedRequest);
                return (UpdateScriptResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ApmSyntheticPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmSyntheticClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApmSyntheticClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApmSyntheticClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

