/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apmsynthetics.model.MonitorResult;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorResultRequest;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResultResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMonitorResultConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetMonitorResultConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetMonitorResultRequest interceptRequest(GetMonitorResultRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetMonitorResultRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getApmDomainId(), (String)"apmDomainId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getVantagePoint(), (String)"vantagePoint is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getResultType(), (String)"resultType is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getResultContentType(), (String)"resultContentType is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExecutionTime(), (String)"executionTime must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("monitors").path(HttpUtils.encodePathSegment((String)request.getMonitorId())).path("results").path(HttpUtils.encodePathSegment((String)request.getExecutionTime()));
        target = target.queryParam("apmDomainId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getApmDomainId())});
        target = target.queryParam("vantagePoint", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getVantagePoint())});
        target = target.queryParam("resultType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResultType())});
        target = target.queryParam("resultContentType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResultContentType())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetMonitorResultResponse> fromResponse() {
        Function<Response, GetMonitorResultResponse> transformer = new Function<Response, GetMonitorResultResponse>(){

            public GetMonitorResultResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.apmsynthetics.responses.GetMonitorResultResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(MonitorResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetMonitorResultResponse.Builder builder = GetMonitorResultResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.monitorResult((MonitorResult)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetMonitorResultResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

