/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmsynthetics.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListScriptsRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String opcRequestId;
    private String displayName;
    private String contentType;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"apmDomainId", "opcRequestId", "displayName", "contentType", "limit", "page", "sortOrder", "sortBy"})
    ListScriptsRequest(String apmDomainId, String opcRequestId, String displayName, String contentType, Integer limit, String page, SortOrders sortOrder, SortBy sortBy) {
        this.apmDomainId = apmDomainId;
        this.opcRequestId = opcRequestId;
        this.displayName = displayName;
        this.contentType = contentType;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScriptsRequest, Void> {
        private String apmDomainId;
        private String opcRequestId;
        private String displayName;
        private String contentType;
        private Integer limit;
        private String page;
        private SortOrders sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScriptsRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.opcRequestId(o.getOpcRequestId());
            this.displayName(o.getDisplayName());
            this.contentType(o.getContentType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScriptsRequest build() {
            ListScriptsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListScriptsRequest buildWithoutInvocationCallback() {
            return new ListScriptsRequest(this.apmDomainId, this.opcRequestId, this.displayName, this.contentType, this.limit, this.page, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListScriptsRequest.Builder(apmDomainId=" + this.apmDomainId + ", opcRequestId=" + this.opcRequestId + ", displayName=" + this.displayName + ", contentType=" + this.contentType + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        ContentType("contentType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

