/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apmtraces.Query;
import com.oracle.bmc.apmtraces.model.QuickPickSummary;
import com.oracle.bmc.apmtraces.requests.ListQuickPicksRequest;
import com.oracle.bmc.apmtraces.responses.ListQuickPicksResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class QueryPaginators {
    private final Query client;

    public Iterable<ListQuickPicksResponse> listQuickPicksResponseIterator(final ListQuickPicksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListQuickPicksRequest.Builder>(){

            public ListQuickPicksRequest.Builder get() {
                return ListQuickPicksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, String>(){

            public String apply(ListQuickPicksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuickPicksRequest.Builder>, ListQuickPicksRequest>(){

            public ListQuickPicksRequest apply(RequestBuilderAndToken<ListQuickPicksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListQuickPicksRequest, ListQuickPicksResponse>(){

            public ListQuickPicksResponse apply(ListQuickPicksRequest request) {
                return QueryPaginators.this.client.listQuickPicks(request);
            }
        });
    }

    public Iterable<QuickPickSummary> listQuickPicksRecordIterator(final ListQuickPicksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListQuickPicksRequest.Builder>(){

            public ListQuickPicksRequest.Builder get() {
                return ListQuickPicksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, String>(){

            public String apply(ListQuickPicksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuickPicksRequest.Builder>, ListQuickPicksRequest>(){

            public ListQuickPicksRequest apply(RequestBuilderAndToken<ListQuickPicksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListQuickPicksRequest, ListQuickPicksResponse>(){

            public ListQuickPicksResponse apply(ListQuickPicksRequest request) {
                return QueryPaginators.this.client.listQuickPicks(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, List<QuickPickSummary>>(){

            public List<QuickPickSummary> apply(ListQuickPicksResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public QueryPaginators(Query client) {
        this.client = client;
    }
}

