/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.blockchain.BlockchainPlatformAsync;
import com.oracle.bmc.blockchain.internal.http.ChangeBlockchainPlatformCompartmentConverter;
import com.oracle.bmc.blockchain.internal.http.CreateBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.CreateOsnConverter;
import com.oracle.bmc.blockchain.internal.http.CreatePeerConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteOsnConverter;
import com.oracle.bmc.blockchain.internal.http.DeletePeerConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.blockchain.internal.http.GetBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.GetOsnConverter;
import com.oracle.bmc.blockchain.internal.http.GetPeerConverter;
import com.oracle.bmc.blockchain.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.blockchain.internal.http.ListBlockchainPlatformsConverter;
import com.oracle.bmc.blockchain.internal.http.ListOsnsConverter;
import com.oracle.bmc.blockchain.internal.http.ListPeersConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.blockchain.internal.http.PreviewScaleBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.ScaleBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.StartBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.StopBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.UpdateBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.UpdateOsnConverter;
import com.oracle.bmc.blockchain.internal.http.UpdatePeerConverter;
import com.oracle.bmc.blockchain.requests.ChangeBlockchainPlatformCompartmentRequest;
import com.oracle.bmc.blockchain.requests.CreateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.CreateOsnRequest;
import com.oracle.bmc.blockchain.requests.CreatePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.DeleteOsnRequest;
import com.oracle.bmc.blockchain.requests.DeletePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.ScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StartBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StopBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateOsnRequest;
import com.oracle.bmc.blockchain.requests.UpdatePeerRequest;
import com.oracle.bmc.blockchain.responses.ChangeBlockchainPlatformCompartmentResponse;
import com.oracle.bmc.blockchain.responses.CreateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.CreateOsnResponse;
import com.oracle.bmc.blockchain.responses.CreatePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.DeleteOsnResponse;
import com.oracle.bmc.blockchain.responses.DeletePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.ScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StartBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StopBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateOsnResponse;
import com.oracle.bmc.blockchain.responses.UpdatePeerResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockchainPlatformAsyncClient
implements BlockchainPlatformAsync {
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainPlatformAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKCHAINPLATFORM").serviceEndpointPrefix("").serviceEndpointTemplate("https://blockchain.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeBlockchainPlatformCompartmentResponse> changeBlockchainPlatformCompartment(ChangeBlockchainPlatformCompartmentRequest request, AsyncHandler<ChangeBlockchainPlatformCompartmentRequest, ChangeBlockchainPlatformCompartmentResponse> handler) {
        LOG.trace("Called async changeBlockchainPlatformCompartment");
        ChangeBlockchainPlatformCompartmentRequest interceptedRequest = ChangeBlockchainPlatformCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBlockchainPlatformCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBlockchainPlatformCompartmentResponse> transformer = ChangeBlockchainPlatformCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeBlockchainPlatformCompartmentRequest, ChangeBlockchainPlatformCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeBlockchainPlatformCompartmentRequest, ChangeBlockchainPlatformCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBlockchainPlatformResponse> createBlockchainPlatform(CreateBlockchainPlatformRequest request, AsyncHandler<CreateBlockchainPlatformRequest, CreateBlockchainPlatformResponse> handler) {
        LOG.trace("Called async createBlockchainPlatform");
        CreateBlockchainPlatformRequest interceptedRequest = CreateBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBlockchainPlatformResponse> transformer = CreateBlockchainPlatformConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBlockchainPlatformRequest, CreateBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBlockchainPlatformRequest, CreateBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOsnResponse> createOsn(CreateOsnRequest request, AsyncHandler<CreateOsnRequest, CreateOsnResponse> handler) {
        LOG.trace("Called async createOsn");
        CreateOsnRequest interceptedRequest = CreateOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOsnResponse> transformer = CreateOsnConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateOsnRequest, CreateOsnResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOsnRequest, CreateOsnResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePeerResponse> createPeer(CreatePeerRequest request, AsyncHandler<CreatePeerRequest, CreatePeerResponse> handler) {
        LOG.trace("Called async createPeer");
        CreatePeerRequest interceptedRequest = CreatePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePeerResponse> transformer = CreatePeerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePeerRequest, CreatePeerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePeerRequest, CreatePeerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBlockchainPlatformResponse> deleteBlockchainPlatform(DeleteBlockchainPlatformRequest request, AsyncHandler<DeleteBlockchainPlatformRequest, DeleteBlockchainPlatformResponse> handler) {
        LOG.trace("Called async deleteBlockchainPlatform");
        DeleteBlockchainPlatformRequest interceptedRequest = DeleteBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBlockchainPlatformResponse> transformer = DeleteBlockchainPlatformConverter.fromResponse();
        AsyncHandler<DeleteBlockchainPlatformRequest, DeleteBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBlockchainPlatformRequest, DeleteBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteOsnResponse> deleteOsn(DeleteOsnRequest request, AsyncHandler<DeleteOsnRequest, DeleteOsnResponse> handler) {
        LOG.trace("Called async deleteOsn");
        DeleteOsnRequest interceptedRequest = DeleteOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOsnResponse> transformer = DeleteOsnConverter.fromResponse();
        AsyncHandler<DeleteOsnRequest, DeleteOsnResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteOsnRequest, DeleteOsnResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePeerResponse> deletePeer(DeletePeerRequest request, AsyncHandler<DeletePeerRequest, DeletePeerResponse> handler) {
        LOG.trace("Called async deletePeer");
        DeletePeerRequest interceptedRequest = DeletePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePeerResponse> transformer = DeletePeerConverter.fromResponse();
        AsyncHandler<DeletePeerRequest, DeletePeerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePeerRequest, DeletePeerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        LOG.trace("Called async deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteWorkRequestRequest, DeleteWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBlockchainPlatformResponse> getBlockchainPlatform(GetBlockchainPlatformRequest request, AsyncHandler<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> handler) {
        LOG.trace("Called async getBlockchainPlatform");
        GetBlockchainPlatformRequest interceptedRequest = GetBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBlockchainPlatformResponse> transformer = GetBlockchainPlatformConverter.fromResponse();
        AsyncHandler<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetOsnResponse> getOsn(GetOsnRequest request, AsyncHandler<GetOsnRequest, GetOsnResponse> handler) {
        LOG.trace("Called async getOsn");
        GetOsnRequest interceptedRequest = GetOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetOsnResponse> transformer = GetOsnConverter.fromResponse();
        AsyncHandler<GetOsnRequest, GetOsnResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetOsnRequest, GetOsnResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPeerResponse> getPeer(GetPeerRequest request, AsyncHandler<GetPeerRequest, GetPeerResponse> handler) {
        LOG.trace("Called async getPeer");
        GetPeerRequest interceptedRequest = GetPeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPeerResponse> transformer = GetPeerConverter.fromResponse();
        AsyncHandler<GetPeerRequest, GetPeerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPeerRequest, GetPeerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBlockchainPlatformsResponse> listBlockchainPlatforms(ListBlockchainPlatformsRequest request, AsyncHandler<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse> handler) {
        LOG.trace("Called async listBlockchainPlatforms");
        ListBlockchainPlatformsRequest interceptedRequest = ListBlockchainPlatformsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBlockchainPlatformsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBlockchainPlatformsResponse> transformer = ListBlockchainPlatformsConverter.fromResponse();
        AsyncHandler<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListOsnsResponse> listOsns(ListOsnsRequest request, AsyncHandler<ListOsnsRequest, ListOsnsResponse> handler) {
        LOG.trace("Called async listOsns");
        ListOsnsRequest interceptedRequest = ListOsnsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOsnsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOsnsResponse> transformer = ListOsnsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ListOsnsRequest, ListOsnsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListOsnsRequest, ListOsnsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPeersResponse> listPeers(ListPeersRequest request, AsyncHandler<ListPeersRequest, ListPeersResponse> handler) {
        LOG.trace("Called async listPeers");
        ListPeersRequest interceptedRequest = ListPeersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPeersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPeersResponse> transformer = ListPeersConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ListPeersRequest, ListPeersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPeersRequest, ListPeersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PreviewScaleBlockchainPlatformResponse> previewScaleBlockchainPlatform(PreviewScaleBlockchainPlatformRequest request, AsyncHandler<PreviewScaleBlockchainPlatformRequest, PreviewScaleBlockchainPlatformResponse> handler) {
        LOG.trace("Called async previewScaleBlockchainPlatform");
        PreviewScaleBlockchainPlatformRequest interceptedRequest = PreviewScaleBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PreviewScaleBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PreviewScaleBlockchainPlatformResponse> transformer = PreviewScaleBlockchainPlatformConverter.fromResponse();
        AsyncHandler<PreviewScaleBlockchainPlatformRequest, PreviewScaleBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PreviewScaleBlockchainPlatformRequest, PreviewScaleBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScaleBlockchainPlatformResponse> scaleBlockchainPlatform(ScaleBlockchainPlatformRequest request, AsyncHandler<ScaleBlockchainPlatformRequest, ScaleBlockchainPlatformResponse> handler) {
        LOG.trace("Called async scaleBlockchainPlatform");
        ScaleBlockchainPlatformRequest interceptedRequest = ScaleBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScaleBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScaleBlockchainPlatformResponse> transformer = ScaleBlockchainPlatformConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ScaleBlockchainPlatformRequest, ScaleBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScaleBlockchainPlatformRequest, ScaleBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartBlockchainPlatformResponse> startBlockchainPlatform(StartBlockchainPlatformRequest request, AsyncHandler<StartBlockchainPlatformRequest, StartBlockchainPlatformResponse> handler) {
        LOG.trace("Called async startBlockchainPlatform");
        StartBlockchainPlatformRequest interceptedRequest = StartBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartBlockchainPlatformResponse> transformer = StartBlockchainPlatformConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartBlockchainPlatformRequest, StartBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartBlockchainPlatformRequest, StartBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopBlockchainPlatformResponse> stopBlockchainPlatform(StopBlockchainPlatformRequest request, AsyncHandler<StopBlockchainPlatformRequest, StopBlockchainPlatformResponse> handler) {
        LOG.trace("Called async stopBlockchainPlatform");
        StopBlockchainPlatformRequest interceptedRequest = StopBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopBlockchainPlatformResponse> transformer = StopBlockchainPlatformConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopBlockchainPlatformRequest, StopBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopBlockchainPlatformRequest, StopBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBlockchainPlatformResponse> updateBlockchainPlatform(UpdateBlockchainPlatformRequest request, AsyncHandler<UpdateBlockchainPlatformRequest, UpdateBlockchainPlatformResponse> handler) {
        LOG.trace("Called async updateBlockchainPlatform");
        UpdateBlockchainPlatformRequest interceptedRequest = UpdateBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBlockchainPlatformResponse> transformer = UpdateBlockchainPlatformConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateBlockchainPlatformRequest, UpdateBlockchainPlatformResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBlockchainPlatformRequest, UpdateBlockchainPlatformResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateOsnResponse> updateOsn(UpdateOsnRequest request, AsyncHandler<UpdateOsnRequest, UpdateOsnResponse> handler) {
        LOG.trace("Called async updateOsn");
        UpdateOsnRequest interceptedRequest = UpdateOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOsnResponse> transformer = UpdateOsnConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateOsnRequest, UpdateOsnResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateOsnRequest, UpdateOsnResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePeerResponse> updatePeer(UpdatePeerRequest request, AsyncHandler<UpdatePeerRequest, UpdatePeerResponse> handler) {
        LOG.trace("Called async updatePeer");
        UpdatePeerRequest interceptedRequest = UpdatePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePeerResponse> transformer = UpdatePeerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdatePeerRequest, UpdatePeerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePeerRequest, UpdatePeerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockchainPlatformAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BlockchainPlatformAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new BlockchainPlatformAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

