/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.blockchain.BlockchainPlatform;
import com.oracle.bmc.blockchain.BlockchainPlatformPaginators;
import com.oracle.bmc.blockchain.BlockchainPlatformWaiters;
import com.oracle.bmc.blockchain.internal.http.ChangeBlockchainPlatformCompartmentConverter;
import com.oracle.bmc.blockchain.internal.http.CreateBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.CreateOsnConverter;
import com.oracle.bmc.blockchain.internal.http.CreatePeerConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteOsnConverter;
import com.oracle.bmc.blockchain.internal.http.DeletePeerConverter;
import com.oracle.bmc.blockchain.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.blockchain.internal.http.GetBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.GetOsnConverter;
import com.oracle.bmc.blockchain.internal.http.GetPeerConverter;
import com.oracle.bmc.blockchain.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.blockchain.internal.http.ListBlockchainPlatformsConverter;
import com.oracle.bmc.blockchain.internal.http.ListOsnsConverter;
import com.oracle.bmc.blockchain.internal.http.ListPeersConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.blockchain.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.blockchain.internal.http.PreviewScaleBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.ScaleBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.StartBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.StopBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.UpdateBlockchainPlatformConverter;
import com.oracle.bmc.blockchain.internal.http.UpdateOsnConverter;
import com.oracle.bmc.blockchain.internal.http.UpdatePeerConverter;
import com.oracle.bmc.blockchain.requests.ChangeBlockchainPlatformCompartmentRequest;
import com.oracle.bmc.blockchain.requests.CreateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.CreateOsnRequest;
import com.oracle.bmc.blockchain.requests.CreatePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.DeleteOsnRequest;
import com.oracle.bmc.blockchain.requests.DeletePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.ScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StartBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StopBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateOsnRequest;
import com.oracle.bmc.blockchain.requests.UpdatePeerRequest;
import com.oracle.bmc.blockchain.responses.ChangeBlockchainPlatformCompartmentResponse;
import com.oracle.bmc.blockchain.responses.CreateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.CreateOsnResponse;
import com.oracle.bmc.blockchain.responses.CreatePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.DeleteOsnResponse;
import com.oracle.bmc.blockchain.responses.DeletePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.ScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StartBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StopBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateOsnResponse;
import com.oracle.bmc.blockchain.responses.UpdatePeerResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockchainPlatformClient
implements BlockchainPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainPlatformClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKCHAINPLATFORM").serviceEndpointPrefix("").serviceEndpointTemplate("https://blockchain.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final BlockchainPlatformWaiters waiters;
    private final BlockchainPlatformPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("BlockchainPlatform-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BlockchainPlatformWaiters(executorService, this);
        this.paginators = new BlockchainPlatformPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeBlockchainPlatformCompartmentResponse changeBlockchainPlatformCompartment(ChangeBlockchainPlatformCompartmentRequest request) {
        LOG.trace("Called changeBlockchainPlatformCompartment");
        ChangeBlockchainPlatformCompartmentRequest interceptedRequest = ChangeBlockchainPlatformCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBlockchainPlatformCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBlockchainPlatformCompartmentResponse> transformer = ChangeBlockchainPlatformCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeBlockchainPlatformCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeBlockchainPlatformCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeBlockchainPlatformCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeBlockchainPlatformCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBlockchainPlatformResponse createBlockchainPlatform(CreateBlockchainPlatformRequest request) {
        LOG.trace("Called createBlockchainPlatform");
        CreateBlockchainPlatformRequest interceptedRequest = CreateBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBlockchainPlatformResponse> transformer = CreateBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBlockchainPlatformDetails(), (BmcRequest)retriedRequest);
                return (CreateBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOsnResponse createOsn(CreateOsnRequest request) {
        LOG.trace("Called createOsn");
        CreateOsnRequest interceptedRequest = CreateOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOsnResponse> transformer = CreateOsnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateOsnResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateOsnResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateOsnDetails(), (BmcRequest)retriedRequest);
                return (CreateOsnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePeerResponse createPeer(CreatePeerRequest request) {
        LOG.trace("Called createPeer");
        CreatePeerRequest interceptedRequest = CreatePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePeerResponse> transformer = CreatePeerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePeerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePeerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePeerDetails(), (BmcRequest)retriedRequest);
                return (CreatePeerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBlockchainPlatformResponse deleteBlockchainPlatform(DeleteBlockchainPlatformRequest request) {
        LOG.trace("Called deleteBlockchainPlatform");
        DeleteBlockchainPlatformRequest interceptedRequest = DeleteBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBlockchainPlatformResponse> transformer = DeleteBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteOsnResponse deleteOsn(DeleteOsnRequest request) {
        LOG.trace("Called deleteOsn");
        DeleteOsnRequest interceptedRequest = DeleteOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOsnResponse> transformer = DeleteOsnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteOsnResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteOsnResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteOsnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePeerResponse deletePeer(DeletePeerRequest request) {
        LOG.trace("Called deletePeer");
        DeletePeerRequest interceptedRequest = DeletePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePeerResponse> transformer = DeletePeerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePeerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePeerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePeerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        LOG.trace("Called deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBlockchainPlatformResponse getBlockchainPlatform(GetBlockchainPlatformRequest request) {
        LOG.trace("Called getBlockchainPlatform");
        GetBlockchainPlatformRequest interceptedRequest = GetBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBlockchainPlatformResponse> transformer = GetBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetOsnResponse getOsn(GetOsnRequest request) {
        LOG.trace("Called getOsn");
        GetOsnRequest interceptedRequest = GetOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetOsnResponse> transformer = GetOsnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetOsnResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetOsnResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetOsnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPeerResponse getPeer(GetPeerRequest request) {
        LOG.trace("Called getPeer");
        GetPeerRequest interceptedRequest = GetPeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPeerResponse> transformer = GetPeerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPeerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPeerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPeerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBlockchainPlatformsResponse listBlockchainPlatforms(ListBlockchainPlatformsRequest request) {
        LOG.trace("Called listBlockchainPlatforms");
        ListBlockchainPlatformsRequest interceptedRequest = ListBlockchainPlatformsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBlockchainPlatformsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBlockchainPlatformsResponse> transformer = ListBlockchainPlatformsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBlockchainPlatformsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBlockchainPlatformsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBlockchainPlatformsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListOsnsResponse listOsns(ListOsnsRequest request) {
        LOG.trace("Called listOsns");
        ListOsnsRequest interceptedRequest = ListOsnsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOsnsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOsnsResponse> transformer = ListOsnsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ListOsnsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListOsnsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListOsnsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPeersResponse listPeers(ListPeersRequest request) {
        LOG.trace("Called listPeers");
        ListPeersRequest interceptedRequest = ListPeersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPeersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPeersResponse> transformer = ListPeersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ListPeersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPeersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPeersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PreviewScaleBlockchainPlatformResponse previewScaleBlockchainPlatform(PreviewScaleBlockchainPlatformRequest request) {
        LOG.trace("Called previewScaleBlockchainPlatform");
        PreviewScaleBlockchainPlatformRequest interceptedRequest = PreviewScaleBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PreviewScaleBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PreviewScaleBlockchainPlatformResponse> transformer = PreviewScaleBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PreviewScaleBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PreviewScaleBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getScaleBlockchainPlatformDetails(), (BmcRequest)retriedRequest);
                return (PreviewScaleBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ScaleBlockchainPlatformResponse scaleBlockchainPlatform(ScaleBlockchainPlatformRequest request) {
        LOG.trace("Called scaleBlockchainPlatform");
        ScaleBlockchainPlatformRequest interceptedRequest = ScaleBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScaleBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScaleBlockchainPlatformResponse> transformer = ScaleBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ScaleBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ScaleBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getScaleBlockchainPlatformDetails(), (BmcRequest)retriedRequest);
                return (ScaleBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartBlockchainPlatformResponse startBlockchainPlatform(StartBlockchainPlatformRequest request) {
        LOG.trace("Called startBlockchainPlatform");
        StartBlockchainPlatformRequest interceptedRequest = StartBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartBlockchainPlatformResponse> transformer = StartBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopBlockchainPlatformResponse stopBlockchainPlatform(StopBlockchainPlatformRequest request) {
        LOG.trace("Called stopBlockchainPlatform");
        StopBlockchainPlatformRequest interceptedRequest = StopBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopBlockchainPlatformResponse> transformer = StopBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StopBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBlockchainPlatformResponse updateBlockchainPlatform(UpdateBlockchainPlatformRequest request) {
        LOG.trace("Called updateBlockchainPlatform");
        UpdateBlockchainPlatformRequest interceptedRequest = UpdateBlockchainPlatformConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBlockchainPlatformConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBlockchainPlatformResponse> transformer = UpdateBlockchainPlatformConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateBlockchainPlatformResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBlockchainPlatformResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBlockchainPlatformDetails(), (BmcRequest)retriedRequest);
                return (UpdateBlockchainPlatformResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateOsnResponse updateOsn(UpdateOsnRequest request) {
        LOG.trace("Called updateOsn");
        UpdateOsnRequest interceptedRequest = UpdateOsnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOsnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOsnResponse> transformer = UpdateOsnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateOsnResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateOsnResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateOsnDetails(), (BmcRequest)retriedRequest);
                return (UpdateOsnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePeerResponse updatePeer(UpdatePeerRequest request) {
        LOG.trace("Called updatePeer");
        UpdatePeerRequest interceptedRequest = UpdatePeerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePeerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePeerResponse> transformer = UpdatePeerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdatePeerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePeerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePeerDetails(), (BmcRequest)retriedRequest);
                return (UpdatePeerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BlockchainPlatformWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BlockchainPlatformPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockchainPlatformClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BlockchainPlatformClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new BlockchainPlatformClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

