/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.blockchain.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.Osn;
import com.oracle.bmc.blockchain.model.Peer;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class BlockchainPlatformWaiters {
    private final ExecutorService executorService;
    private final BlockchainPlatform client;

    public Waiter<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> forBlockchainPlatform(GetBlockchainPlatformRequest request, BlockchainPlatform.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBlockchainPlatform(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> forBlockchainPlatform(GetBlockchainPlatformRequest request, BlockchainPlatform.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBlockchainPlatform(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> forBlockchainPlatform(GetBlockchainPlatformRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BlockchainPlatform.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBlockchainPlatform(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> forBlockchainPlatform(BmcGenericWaiter waiter, GetBlockchainPlatformRequest request, BlockchainPlatform.LifecycleState ... targetStates) {
        final HashSet<BlockchainPlatform.LifecycleState> targetStatesSet = new HashSet<BlockchainPlatform.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse>(){

            public GetBlockchainPlatformResponse apply(GetBlockchainPlatformRequest request) {
                return BlockchainPlatformWaiters.this.client.getBlockchainPlatform(request);
            }
        }, (Predicate)new Predicate<GetBlockchainPlatformResponse>(){

            public boolean apply(GetBlockchainPlatformResponse response) {
                return targetStatesSet.contains((Object)response.getBlockchainPlatform().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BlockchainPlatform.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOsnRequest, GetOsnResponse> forOsn(GetOsnRequest request, Osn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOsn(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOsnRequest, GetOsnResponse> forOsn(GetOsnRequest request, Osn.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOsn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOsnRequest, GetOsnResponse> forOsn(GetOsnRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Osn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOsn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOsnRequest, GetOsnResponse> forOsn(BmcGenericWaiter waiter, GetOsnRequest request, Osn.LifecycleState ... targetStates) {
        final HashSet<Osn.LifecycleState> targetStatesSet = new HashSet<Osn.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetOsnRequest, GetOsnResponse>(){

            public GetOsnResponse apply(GetOsnRequest request) {
                return BlockchainPlatformWaiters.this.client.getOsn(request);
            }
        }, (Predicate)new Predicate<GetOsnResponse>(){

            public boolean apply(GetOsnResponse response) {
                return targetStatesSet.contains((Object)response.getOsn().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetPeerRequest, GetPeerResponse> forPeer(GetPeerRequest request, Peer.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPeer(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPeerRequest, GetPeerResponse> forPeer(GetPeerRequest request, Peer.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPeer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPeerRequest, GetPeerResponse> forPeer(GetPeerRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Peer.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPeer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPeerRequest, GetPeerResponse> forPeer(BmcGenericWaiter waiter, GetPeerRequest request, Peer.LifecycleState ... targetStates) {
        final HashSet<Peer.LifecycleState> targetStatesSet = new HashSet<Peer.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetPeerRequest, GetPeerResponse>(){

            public GetPeerResponse apply(GetPeerRequest request) {
                return BlockchainPlatformWaiters.this.client.getPeer(request);
            }
        }, (Predicate)new Predicate<GetPeerResponse>(){

            public boolean apply(GetPeerResponse response) {
                return targetStatesSet.contains((Object)response.getPeer().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return BlockchainPlatformWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public BlockchainPlatformWaiters(ExecutorService executorService, BlockchainPlatform client) {
        this.executorService = executorService;
        this.client = client;
    }
}

