/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.blockchain.model.Osn;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOsnConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetOsnConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetOsnRequest interceptRequest(GetOsnRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetOsnRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20191010").path("blockchainPlatforms").path(HttpUtils.encodePathSegment((String)request.getBlockchainPlatformId())).path("osns").path(HttpUtils.encodePathSegment((String)request.getOsnId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetOsnResponse> fromResponse() {
        Function<Response, GetOsnResponse> transformer = new Function<Response, GetOsnResponse>(){

            public GetOsnResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.blockchain.responses.GetOsnResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Osn.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetOsnResponse.Builder builder = GetOsnResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.osn((Osn)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetOsnResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

