/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.BlockchainPlatformComponentDetails;
import com.oracle.bmc.blockchain.model.OcpuUtilizationInfo;
import com.oracle.bmc.blockchain.model.ReplicaDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockchainPlatform {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="serviceVersion")
    private final String serviceVersion;
    @JsonProperty(value="platformRole")
    private final PlatformRole platformRole;
    @JsonProperty(value="computeShape")
    private final ComputeShape computeShape;
    @JsonProperty(value="platformShapeType")
    private final PlatformShapeType platformShapeType;
    @JsonProperty(value="loadBalancerShape")
    private final LoadBalancerShape loadBalancerShape;
    @JsonProperty(value="serviceEndpoint")
    private final String serviceEndpoint;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="storageSizeInTBs")
    private final Double storageSizeInTBs;
    @JsonProperty(value="storageUsedInTBs")
    private final Double storageUsedInTBs;
    @JsonProperty(value="isMultiAD")
    private final Boolean isMultiAD;
    @JsonProperty(value="totalOcpuCapacity")
    private final Integer totalOcpuCapacity;
    @JsonProperty(value="componentDetails")
    private final BlockchainPlatformComponentDetails componentDetails;
    @JsonProperty(value="replicas")
    private final ReplicaDetails replicas;
    @JsonProperty(value="hostOcpuUtilizationInfo")
    private final List<OcpuUtilizationInfo> hostOcpuUtilizationInfo;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).displayName(this.displayName).compartmentId(this.compartmentId).description(this.description).isByol(this.isByol).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).serviceVersion(this.serviceVersion).platformRole(this.platformRole).computeShape(this.computeShape).platformShapeType(this.platformShapeType).loadBalancerShape(this.loadBalancerShape).serviceEndpoint(this.serviceEndpoint).lifecycleState(this.lifecycleState).lifecycleDetails(this.lifecycleDetails).storageSizeInTBs(this.storageSizeInTBs).storageUsedInTBs(this.storageUsedInTBs).isMultiAD(this.isMultiAD).totalOcpuCapacity(this.totalOcpuCapacity).componentDetails(this.componentDetails).replicas(this.replicas).hostOcpuUtilizationInfo(this.hostOcpuUtilizationInfo).freeformTags(this.freeformTags).definedTags(this.definedTags);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public PlatformRole getPlatformRole() {
        return this.platformRole;
    }

    public ComputeShape getComputeShape() {
        return this.computeShape;
    }

    public PlatformShapeType getPlatformShapeType() {
        return this.platformShapeType;
    }

    public LoadBalancerShape getLoadBalancerShape() {
        return this.loadBalancerShape;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Double getStorageSizeInTBs() {
        return this.storageSizeInTBs;
    }

    public Double getStorageUsedInTBs() {
        return this.storageUsedInTBs;
    }

    public Boolean getIsMultiAD() {
        return this.isMultiAD;
    }

    public Integer getTotalOcpuCapacity() {
        return this.totalOcpuCapacity;
    }

    public BlockchainPlatformComponentDetails getComponentDetails() {
        return this.componentDetails;
    }

    public ReplicaDetails getReplicas() {
        return this.replicas;
    }

    public List<OcpuUtilizationInfo> getHostOcpuUtilizationInfo() {
        return this.hostOcpuUtilizationInfo;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockchainPlatform)) {
            return false;
        }
        BlockchainPlatform other = (BlockchainPlatform)o;
        Boolean this$isByol = this.getIsByol();
        Boolean other$isByol = other.getIsByol();
        if (this$isByol == null ? other$isByol != null : !((Object)this$isByol).equals(other$isByol)) {
            return false;
        }
        Double this$storageSizeInTBs = this.getStorageSizeInTBs();
        Double other$storageSizeInTBs = other.getStorageSizeInTBs();
        if (this$storageSizeInTBs == null ? other$storageSizeInTBs != null : !((Object)this$storageSizeInTBs).equals(other$storageSizeInTBs)) {
            return false;
        }
        Double this$storageUsedInTBs = this.getStorageUsedInTBs();
        Double other$storageUsedInTBs = other.getStorageUsedInTBs();
        if (this$storageUsedInTBs == null ? other$storageUsedInTBs != null : !((Object)this$storageUsedInTBs).equals(other$storageUsedInTBs)) {
            return false;
        }
        Boolean this$isMultiAD = this.getIsMultiAD();
        Boolean other$isMultiAD = other.getIsMultiAD();
        if (this$isMultiAD == null ? other$isMultiAD != null : !((Object)this$isMultiAD).equals(other$isMultiAD)) {
            return false;
        }
        Integer this$totalOcpuCapacity = this.getTotalOcpuCapacity();
        Integer other$totalOcpuCapacity = other.getTotalOcpuCapacity();
        if (this$totalOcpuCapacity == null ? other$totalOcpuCapacity != null : !((Object)this$totalOcpuCapacity).equals(other$totalOcpuCapacity)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeUpdated = this.getTimeUpdated();
        Date other$timeUpdated = other.getTimeUpdated();
        if (this$timeUpdated == null ? other$timeUpdated != null : !((Object)this$timeUpdated).equals(other$timeUpdated)) {
            return false;
        }
        String this$serviceVersion = this.getServiceVersion();
        String other$serviceVersion = other.getServiceVersion();
        if (this$serviceVersion == null ? other$serviceVersion != null : !this$serviceVersion.equals(other$serviceVersion)) {
            return false;
        }
        PlatformRole this$platformRole = this.getPlatformRole();
        PlatformRole other$platformRole = other.getPlatformRole();
        if (this$platformRole == null ? other$platformRole != null : !((Object)((Object)this$platformRole)).equals((Object)other$platformRole)) {
            return false;
        }
        ComputeShape this$computeShape = this.getComputeShape();
        ComputeShape other$computeShape = other.getComputeShape();
        if (this$computeShape == null ? other$computeShape != null : !((Object)((Object)this$computeShape)).equals((Object)other$computeShape)) {
            return false;
        }
        PlatformShapeType this$platformShapeType = this.getPlatformShapeType();
        PlatformShapeType other$platformShapeType = other.getPlatformShapeType();
        if (this$platformShapeType == null ? other$platformShapeType != null : !((Object)((Object)this$platformShapeType)).equals((Object)other$platformShapeType)) {
            return false;
        }
        LoadBalancerShape this$loadBalancerShape = this.getLoadBalancerShape();
        LoadBalancerShape other$loadBalancerShape = other.getLoadBalancerShape();
        if (this$loadBalancerShape == null ? other$loadBalancerShape != null : !((Object)((Object)this$loadBalancerShape)).equals((Object)other$loadBalancerShape)) {
            return false;
        }
        String this$serviceEndpoint = this.getServiceEndpoint();
        String other$serviceEndpoint = other.getServiceEndpoint();
        if (this$serviceEndpoint == null ? other$serviceEndpoint != null : !this$serviceEndpoint.equals(other$serviceEndpoint)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        BlockchainPlatformComponentDetails this$componentDetails = this.getComponentDetails();
        BlockchainPlatformComponentDetails other$componentDetails = other.getComponentDetails();
        if (this$componentDetails == null ? other$componentDetails != null : !((Object)this$componentDetails).equals(other$componentDetails)) {
            return false;
        }
        ReplicaDetails this$replicas = this.getReplicas();
        ReplicaDetails other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        List<OcpuUtilizationInfo> this$hostOcpuUtilizationInfo = this.getHostOcpuUtilizationInfo();
        List<OcpuUtilizationInfo> other$hostOcpuUtilizationInfo = other.getHostOcpuUtilizationInfo();
        if (this$hostOcpuUtilizationInfo == null ? other$hostOcpuUtilizationInfo != null : !((Object)this$hostOcpuUtilizationInfo).equals(other$hostOcpuUtilizationInfo)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isByol = this.getIsByol();
        result = result * 59 + ($isByol == null ? 43 : ((Object)$isByol).hashCode());
        Double $storageSizeInTBs = this.getStorageSizeInTBs();
        result = result * 59 + ($storageSizeInTBs == null ? 43 : ((Object)$storageSizeInTBs).hashCode());
        Double $storageUsedInTBs = this.getStorageUsedInTBs();
        result = result * 59 + ($storageUsedInTBs == null ? 43 : ((Object)$storageUsedInTBs).hashCode());
        Boolean $isMultiAD = this.getIsMultiAD();
        result = result * 59 + ($isMultiAD == null ? 43 : ((Object)$isMultiAD).hashCode());
        Integer $totalOcpuCapacity = this.getTotalOcpuCapacity();
        result = result * 59 + ($totalOcpuCapacity == null ? 43 : ((Object)$totalOcpuCapacity).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeUpdated = this.getTimeUpdated();
        result = result * 59 + ($timeUpdated == null ? 43 : ((Object)$timeUpdated).hashCode());
        String $serviceVersion = this.getServiceVersion();
        result = result * 59 + ($serviceVersion == null ? 43 : $serviceVersion.hashCode());
        PlatformRole $platformRole = this.getPlatformRole();
        result = result * 59 + ($platformRole == null ? 43 : ((Object)((Object)$platformRole)).hashCode());
        ComputeShape $computeShape = this.getComputeShape();
        result = result * 59 + ($computeShape == null ? 43 : ((Object)((Object)$computeShape)).hashCode());
        PlatformShapeType $platformShapeType = this.getPlatformShapeType();
        result = result * 59 + ($platformShapeType == null ? 43 : ((Object)((Object)$platformShapeType)).hashCode());
        LoadBalancerShape $loadBalancerShape = this.getLoadBalancerShape();
        result = result * 59 + ($loadBalancerShape == null ? 43 : ((Object)((Object)$loadBalancerShape)).hashCode());
        String $serviceEndpoint = this.getServiceEndpoint();
        result = result * 59 + ($serviceEndpoint == null ? 43 : $serviceEndpoint.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        BlockchainPlatformComponentDetails $componentDetails = this.getComponentDetails();
        result = result * 59 + ($componentDetails == null ? 43 : ((Object)$componentDetails).hashCode());
        ReplicaDetails $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        List<OcpuUtilizationInfo> $hostOcpuUtilizationInfo = this.getHostOcpuUtilizationInfo();
        result = result * 59 + ($hostOcpuUtilizationInfo == null ? 43 : ((Object)$hostOcpuUtilizationInfo).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "BlockchainPlatform(id=" + this.getId() + ", displayName=" + this.getDisplayName() + ", compartmentId=" + this.getCompartmentId() + ", description=" + this.getDescription() + ", isByol=" + this.getIsByol() + ", timeCreated=" + this.getTimeCreated() + ", timeUpdated=" + this.getTimeUpdated() + ", serviceVersion=" + this.getServiceVersion() + ", platformRole=" + (Object)((Object)this.getPlatformRole()) + ", computeShape=" + (Object)((Object)this.getComputeShape()) + ", platformShapeType=" + (Object)((Object)this.getPlatformShapeType()) + ", loadBalancerShape=" + (Object)((Object)this.getLoadBalancerShape()) + ", serviceEndpoint=" + this.getServiceEndpoint() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecycleDetails=" + this.getLifecycleDetails() + ", storageSizeInTBs=" + this.getStorageSizeInTBs() + ", storageUsedInTBs=" + this.getStorageUsedInTBs() + ", isMultiAD=" + this.getIsMultiAD() + ", totalOcpuCapacity=" + this.getTotalOcpuCapacity() + ", componentDetails=" + this.getComponentDetails() + ", replicas=" + this.getReplicas() + ", hostOcpuUtilizationInfo=" + this.getHostOcpuUtilizationInfo() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "displayName", "compartmentId", "description", "isByol", "timeCreated", "timeUpdated", "serviceVersion", "platformRole", "computeShape", "platformShapeType", "loadBalancerShape", "serviceEndpoint", "lifecycleState", "lifecycleDetails", "storageSizeInTBs", "storageUsedInTBs", "isMultiAD", "totalOcpuCapacity", "componentDetails", "replicas", "hostOcpuUtilizationInfo", "freeformTags", "definedTags"})
    @Deprecated
    public BlockchainPlatform(String id, String displayName, String compartmentId, String description, Boolean isByol, Date timeCreated, Date timeUpdated, String serviceVersion, PlatformRole platformRole, ComputeShape computeShape, PlatformShapeType platformShapeType, LoadBalancerShape loadBalancerShape, String serviceEndpoint, LifecycleState lifecycleState, String lifecycleDetails, Double storageSizeInTBs, Double storageUsedInTBs, Boolean isMultiAD, Integer totalOcpuCapacity, BlockchainPlatformComponentDetails componentDetails, ReplicaDetails replicas, List<OcpuUtilizationInfo> hostOcpuUtilizationInfo, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.description = description;
        this.isByol = isByol;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.serviceVersion = serviceVersion;
        this.platformRole = platformRole;
        this.computeShape = computeShape;
        this.platformShapeType = platformShapeType;
        this.loadBalancerShape = loadBalancerShape;
        this.serviceEndpoint = serviceEndpoint;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.storageSizeInTBs = storageSizeInTBs;
        this.storageUsedInTBs = storageUsedInTBs;
        this.isMultiAD = isMultiAD;
        this.totalOcpuCapacity = totalOcpuCapacity;
        this.componentDetails = componentDetails;
        this.replicas = replicas;
        this.hostOcpuUtilizationInfo = hostOcpuUtilizationInfo;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static enum LifecycleState {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Scaling("SCALING"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LoadBalancerShape {
        Lb100Mbps("LB_100_MBPS"),
        Lb400Mbps("LB_400_MBPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LoadBalancerShape> map;

        private LoadBalancerShape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LoadBalancerShape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LoadBalancerShape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LoadBalancerShape.class);
            map = new HashMap<String, LoadBalancerShape>();
            for (LoadBalancerShape v : LoadBalancerShape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformShapeType {
        Default("DEFAULT"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformShapeType> map;

        private PlatformShapeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformShapeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformShapeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformShapeType.class);
            map = new HashMap<String, PlatformShapeType>();
            for (PlatformShapeType v : PlatformShapeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeShape {
        Standard("STANDARD"),
        EnterpriseSmall("ENTERPRISE_SMALL"),
        EnterpriseMedium("ENTERPRISE_MEDIUM"),
        EnterpriseLarge("ENTERPRISE_LARGE"),
        EnterpriseExtraLarge("ENTERPRISE_EXTRA_LARGE"),
        EnterpriseCustom("ENTERPRISE_CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeShape> map;

        private ComputeShape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeShape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeShape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeShape.class);
            map = new HashMap<String, ComputeShape>();
            for (ComputeShape v : ComputeShape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformRole {
        Founder("FOUNDER"),
        Participant("PARTICIPANT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformRole> map;

        private PlatformRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformRole.class);
            map = new HashMap<String, PlatformRole>();
            for (PlatformRole v : PlatformRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="serviceVersion")
        private String serviceVersion;
        @JsonProperty(value="platformRole")
        private PlatformRole platformRole;
        @JsonProperty(value="computeShape")
        private ComputeShape computeShape;
        @JsonProperty(value="platformShapeType")
        private PlatformShapeType platformShapeType;
        @JsonProperty(value="loadBalancerShape")
        private LoadBalancerShape loadBalancerShape;
        @JsonProperty(value="serviceEndpoint")
        private String serviceEndpoint;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="storageSizeInTBs")
        private Double storageSizeInTBs;
        @JsonProperty(value="storageUsedInTBs")
        private Double storageUsedInTBs;
        @JsonProperty(value="isMultiAD")
        private Boolean isMultiAD;
        @JsonProperty(value="totalOcpuCapacity")
        private Integer totalOcpuCapacity;
        @JsonProperty(value="componentDetails")
        private BlockchainPlatformComponentDetails componentDetails;
        @JsonProperty(value="replicas")
        private ReplicaDetails replicas;
        @JsonProperty(value="hostOcpuUtilizationInfo")
        private List<OcpuUtilizationInfo> hostOcpuUtilizationInfo;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            this.__explicitlySet__.add("serviceVersion");
            return this;
        }

        public Builder platformRole(PlatformRole platformRole) {
            this.platformRole = platformRole;
            this.__explicitlySet__.add("platformRole");
            return this;
        }

        public Builder computeShape(ComputeShape computeShape) {
            this.computeShape = computeShape;
            this.__explicitlySet__.add("computeShape");
            return this;
        }

        public Builder platformShapeType(PlatformShapeType platformShapeType) {
            this.platformShapeType = platformShapeType;
            this.__explicitlySet__.add("platformShapeType");
            return this;
        }

        public Builder loadBalancerShape(LoadBalancerShape loadBalancerShape) {
            this.loadBalancerShape = loadBalancerShape;
            this.__explicitlySet__.add("loadBalancerShape");
            return this;
        }

        public Builder serviceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            this.__explicitlySet__.add("serviceEndpoint");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder storageSizeInTBs(Double storageSizeInTBs) {
            this.storageSizeInTBs = storageSizeInTBs;
            this.__explicitlySet__.add("storageSizeInTBs");
            return this;
        }

        public Builder storageUsedInTBs(Double storageUsedInTBs) {
            this.storageUsedInTBs = storageUsedInTBs;
            this.__explicitlySet__.add("storageUsedInTBs");
            return this;
        }

        public Builder isMultiAD(Boolean isMultiAD) {
            this.isMultiAD = isMultiAD;
            this.__explicitlySet__.add("isMultiAD");
            return this;
        }

        public Builder totalOcpuCapacity(Integer totalOcpuCapacity) {
            this.totalOcpuCapacity = totalOcpuCapacity;
            this.__explicitlySet__.add("totalOcpuCapacity");
            return this;
        }

        public Builder componentDetails(BlockchainPlatformComponentDetails componentDetails) {
            this.componentDetails = componentDetails;
            this.__explicitlySet__.add("componentDetails");
            return this;
        }

        public Builder replicas(ReplicaDetails replicas) {
            this.replicas = replicas;
            this.__explicitlySet__.add("replicas");
            return this;
        }

        public Builder hostOcpuUtilizationInfo(List<OcpuUtilizationInfo> hostOcpuUtilizationInfo) {
            this.hostOcpuUtilizationInfo = hostOcpuUtilizationInfo;
            this.__explicitlySet__.add("hostOcpuUtilizationInfo");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public BlockchainPlatform build() {
            BlockchainPlatform __instance__ = new BlockchainPlatform(this.id, this.displayName, this.compartmentId, this.description, this.isByol, this.timeCreated, this.timeUpdated, this.serviceVersion, this.platformRole, this.computeShape, this.platformShapeType, this.loadBalancerShape, this.serviceEndpoint, this.lifecycleState, this.lifecycleDetails, this.storageSizeInTBs, this.storageUsedInTBs, this.isMultiAD, this.totalOcpuCapacity, this.componentDetails, this.replicas, this.hostOcpuUtilizationInfo, this.freeformTags, this.definedTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(BlockchainPlatform o) {
            Builder copiedBuilder = this.id(o.getId()).displayName(o.getDisplayName()).compartmentId(o.getCompartmentId()).description(o.getDescription()).isByol(o.getIsByol()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).serviceVersion(o.getServiceVersion()).platformRole(o.getPlatformRole()).computeShape(o.getComputeShape()).platformShapeType(o.getPlatformShapeType()).loadBalancerShape(o.getLoadBalancerShape()).serviceEndpoint(o.getServiceEndpoint()).lifecycleState(o.getLifecycleState()).lifecycleDetails(o.getLifecycleDetails()).storageSizeInTBs(o.getStorageSizeInTBs()).storageUsedInTBs(o.getStorageUsedInTBs()).isMultiAD(o.getIsMultiAD()).totalOcpuCapacity(o.getTotalOcpuCapacity()).componentDetails(o.getComponentDetails()).replicas(o.getReplicas()).hostOcpuUtilizationInfo(o.getHostOcpuUtilizationInfo()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "BlockchainPlatform.Builder(id=" + this.id + ", displayName=" + this.displayName + ", compartmentId=" + this.compartmentId + ", description=" + this.description + ", isByol=" + this.isByol + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", serviceVersion=" + this.serviceVersion + ", platformRole=" + (Object)((Object)this.platformRole) + ", computeShape=" + (Object)((Object)this.computeShape) + ", platformShapeType=" + (Object)((Object)this.platformShapeType) + ", loadBalancerShape=" + (Object)((Object)this.loadBalancerShape) + ", serviceEndpoint=" + this.serviceEndpoint + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleDetails=" + this.lifecycleDetails + ", storageSizeInTBs=" + this.storageSizeInTBs + ", storageUsedInTBs=" + this.storageUsedInTBs + ", isMultiAD=" + this.isMultiAD + ", totalOcpuCapacity=" + this.totalOcpuCapacity + ", componentDetails=" + this.componentDetails + ", replicas=" + this.replicas + ", hostOcpuUtilizationInfo=" + this.hostOcpuUtilizationInfo + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ")";
        }
    }
}

