/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.AvailabilityDomain;
import com.oracle.bmc.blockchain.model.OcpuAllocationNumberParam;
import com.oracle.bmc.blockchain.model.PeerRole;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Peer {
    @JsonProperty(value="peerKey")
    private final String peerKey;
    @JsonProperty(value="role")
    private final PeerRole.Role role;
    @JsonProperty(value="alias")
    private final String alias;
    @JsonProperty(value="ocpuAllocationParam")
    private final OcpuAllocationNumberParam ocpuAllocationParam;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="ad")
    private final AvailabilityDomain.Ads ad;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().peerKey(this.peerKey).role(this.role).alias(this.alias).ocpuAllocationParam(this.ocpuAllocationParam).host(this.host).ad(this.ad).lifecycleState(this.lifecycleState);
    }

    public String getPeerKey() {
        return this.peerKey;
    }

    public PeerRole.Role getRole() {
        return this.role;
    }

    public String getAlias() {
        return this.alias;
    }

    public OcpuAllocationNumberParam getOcpuAllocationParam() {
        return this.ocpuAllocationParam;
    }

    public String getHost() {
        return this.host;
    }

    public AvailabilityDomain.Ads getAd() {
        return this.ad;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer other = (Peer)o;
        String this$peerKey = this.getPeerKey();
        String other$peerKey = other.getPeerKey();
        if (this$peerKey == null ? other$peerKey != null : !this$peerKey.equals(other$peerKey)) {
            return false;
        }
        PeerRole.Role this$role = this.getRole();
        PeerRole.Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        OcpuAllocationNumberParam this$ocpuAllocationParam = this.getOcpuAllocationParam();
        OcpuAllocationNumberParam other$ocpuAllocationParam = other.getOcpuAllocationParam();
        if (this$ocpuAllocationParam == null ? other$ocpuAllocationParam != null : !((Object)this$ocpuAllocationParam).equals(other$ocpuAllocationParam)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        AvailabilityDomain.Ads this$ad = this.getAd();
        AvailabilityDomain.Ads other$ad = other.getAd();
        if (this$ad == null ? other$ad != null : !((Object)((Object)this$ad)).equals((Object)other$ad)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $peerKey = this.getPeerKey();
        result = result * 59 + ($peerKey == null ? 43 : $peerKey.hashCode());
        PeerRole.Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        OcpuAllocationNumberParam $ocpuAllocationParam = this.getOcpuAllocationParam();
        result = result * 59 + ($ocpuAllocationParam == null ? 43 : ((Object)$ocpuAllocationParam).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        AvailabilityDomain.Ads $ad = this.getAd();
        result = result * 59 + ($ad == null ? 43 : ((Object)((Object)$ad)).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Peer(peerKey=" + this.getPeerKey() + ", role=" + (Object)((Object)this.getRole()) + ", alias=" + this.getAlias() + ", ocpuAllocationParam=" + this.getOcpuAllocationParam() + ", host=" + this.getHost() + ", ad=" + (Object)((Object)this.getAd()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"peerKey", "role", "alias", "ocpuAllocationParam", "host", "ad", "lifecycleState"})
    @Deprecated
    public Peer(String peerKey, PeerRole.Role role, String alias, OcpuAllocationNumberParam ocpuAllocationParam, String host, AvailabilityDomain.Ads ad, LifecycleState lifecycleState) {
        this.peerKey = peerKey;
        this.role = role;
        this.alias = alias;
        this.ocpuAllocationParam = ocpuAllocationParam;
        this.host = host;
        this.ad = ad;
        this.lifecycleState = lifecycleState;
    }

    public static enum LifecycleState {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="peerKey")
        private String peerKey;
        @JsonProperty(value="role")
        private PeerRole.Role role;
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="ocpuAllocationParam")
        private OcpuAllocationNumberParam ocpuAllocationParam;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="ad")
        private AvailabilityDomain.Ads ad;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder peerKey(String peerKey) {
            this.peerKey = peerKey;
            this.__explicitlySet__.add("peerKey");
            return this;
        }

        public Builder role(PeerRole.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder ocpuAllocationParam(OcpuAllocationNumberParam ocpuAllocationParam) {
            this.ocpuAllocationParam = ocpuAllocationParam;
            this.__explicitlySet__.add("ocpuAllocationParam");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder ad(AvailabilityDomain.Ads ad) {
            this.ad = ad;
            this.__explicitlySet__.add("ad");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Peer build() {
            Peer __instance__ = new Peer(this.peerKey, this.role, this.alias, this.ocpuAllocationParam, this.host, this.ad, this.lifecycleState);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Peer o) {
            Builder copiedBuilder = this.peerKey(o.getPeerKey()).role(o.getRole()).alias(o.getAlias()).ocpuAllocationParam(o.getOcpuAllocationParam()).host(o.getHost()).ad(o.getAd()).lifecycleState(o.getLifecycleState());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Peer.Builder(peerKey=" + this.peerKey + ", role=" + (Object)((Object)this.role) + ", alias=" + this.alias + ", ocpuAllocationParam=" + this.ocpuAllocationParam + ", host=" + this.host + ", ad=" + (Object)((Object)this.ad) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

