/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.CreateOsnDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateOsnRequest
extends BmcRequest<CreateOsnDetails> {
    private String blockchainPlatformId;
    private CreateOsnDetails createOsnDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateOsnDetails getBody$() {
        return this.createOsnDetails;
    }

    @ConstructorProperties(value={"blockchainPlatformId", "createOsnDetails", "ifMatch", "opcRequestId", "opcRetryToken"})
    CreateOsnRequest(String blockchainPlatformId, CreateOsnDetails createOsnDetails, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.createOsnDetails = createOsnDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public CreateOsnDetails getCreateOsnDetails() {
        return this.createOsnDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOsnRequest, CreateOsnDetails> {
        private String blockchainPlatformId;
        private CreateOsnDetails createOsnDetails;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOsnRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.createOsnDetails(o.getCreateOsnDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOsnRequest build() {
            CreateOsnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateOsnDetails body) {
            this.createOsnDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder createOsnDetails(CreateOsnDetails createOsnDetails) {
            this.createOsnDetails = createOsnDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateOsnRequest buildWithoutInvocationCallback() {
            return new CreateOsnRequest(this.blockchainPlatformId, this.createOsnDetails, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateOsnRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", createOsnDetails=" + this.createOsnDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

