/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteOsnRequest
extends BmcRequest<Void> {
    private String blockchainPlatformId;
    private String osnId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"blockchainPlatformId", "osnId", "opcRequestId", "ifMatch"})
    DeleteOsnRequest(String blockchainPlatformId, String osnId, String opcRequestId, String ifMatch) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.osnId = osnId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getOsnId() {
        return this.osnId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteOsnRequest, Void> {
        private String blockchainPlatformId;
        private String osnId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteOsnRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.osnId(o.getOsnId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteOsnRequest build() {
            DeleteOsnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder osnId(String osnId) {
            this.osnId = osnId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteOsnRequest buildWithoutInvocationCallback() {
            return new DeleteOsnRequest(this.blockchainPlatformId, this.osnId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteOsnRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", osnId=" + this.osnId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

