/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeletePeerRequest
extends BmcRequest<Void> {
    private String blockchainPlatformId;
    private String peerId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"blockchainPlatformId", "peerId", "opcRequestId", "ifMatch"})
    DeletePeerRequest(String blockchainPlatformId, String peerId, String opcRequestId, String ifMatch) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.peerId = peerId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeletePeerRequest, Void> {
        private String blockchainPlatformId;
        private String peerId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePeerRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.peerId(o.getPeerId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePeerRequest build() {
            DeletePeerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeletePeerRequest buildWithoutInvocationCallback() {
            return new DeletePeerRequest(this.blockchainPlatformId, this.peerId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeletePeerRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", peerId=" + this.peerId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

