/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPeerRequest
extends BmcRequest<Void> {
    private String blockchainPlatformId;
    private String peerId;
    private String opcRequestId;

    @ConstructorProperties(value={"blockchainPlatformId", "peerId", "opcRequestId"})
    GetPeerRequest(String blockchainPlatformId, String peerId, String opcRequestId) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.peerId = peerId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPeerRequest, Void> {
        private String blockchainPlatformId;
        private String peerId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPeerRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.peerId(o.getPeerId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPeerRequest build() {
            GetPeerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPeerRequest buildWithoutInvocationCallback() {
            return new GetPeerRequest(this.blockchainPlatformId, this.peerId, this.opcRequestId);
        }

        public String toString() {
            return "GetPeerRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", peerId=" + this.peerId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

