/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.budget.BudgetAsync;
import com.oracle.bmc.budget.internal.http.CreateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.CreateBudgetConverter;
import com.oracle.bmc.budget.internal.http.DeleteAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.DeleteBudgetConverter;
import com.oracle.bmc.budget.internal.http.GetAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.GetBudgetConverter;
import com.oracle.bmc.budget.internal.http.ListAlertRulesConverter;
import com.oracle.bmc.budget.internal.http.ListBudgetsConverter;
import com.oracle.bmc.budget.internal.http.UpdateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.UpdateBudgetConverter;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetAsyncClient
implements BudgetAsync {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BUDGET").serviceEndpointPrefix("").serviceEndpointTemplate("https://usage.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateAlertRuleResponse> createAlertRule(CreateAlertRuleRequest request, AsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse> handler) {
        LOG.trace("Called async createAlertRule");
        CreateAlertRuleRequest interceptedRequest = CreateAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAlertRuleResponse> transformer = CreateAlertRuleConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAlertRuleRequest, CreateAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBudgetResponse> createBudget(CreateBudgetRequest request, AsyncHandler<CreateBudgetRequest, CreateBudgetResponse> handler) {
        LOG.trace("Called async createBudget");
        CreateBudgetRequest interceptedRequest = CreateBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBudgetResponse> transformer = CreateBudgetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBudgetRequest, CreateBudgetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBudgetRequest, CreateBudgetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAlertRuleResponse> deleteAlertRule(DeleteAlertRuleRequest request, AsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse> handler) {
        LOG.trace("Called async deleteAlertRule");
        DeleteAlertRuleRequest interceptedRequest = DeleteAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAlertRuleResponse> transformer = DeleteAlertRuleConverter.fromResponse();
        AsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAlertRuleRequest, DeleteAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest request, AsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse> handler) {
        LOG.trace("Called async deleteBudget");
        DeleteBudgetRequest interceptedRequest = DeleteBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBudgetResponse> transformer = DeleteBudgetConverter.fromResponse();
        AsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBudgetRequest, DeleteBudgetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAlertRuleResponse> getAlertRule(GetAlertRuleRequest request, AsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse> handler) {
        LOG.trace("Called async getAlertRule");
        GetAlertRuleRequest interceptedRequest = GetAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlertRuleResponse> transformer = GetAlertRuleConverter.fromResponse();
        AsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAlertRuleRequest, GetAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBudgetResponse> getBudget(GetBudgetRequest request, AsyncHandler<GetBudgetRequest, GetBudgetResponse> handler) {
        LOG.trace("Called async getBudget");
        GetBudgetRequest interceptedRequest = GetBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBudgetResponse> transformer = GetBudgetConverter.fromResponse();
        AsyncHandler<GetBudgetRequest, GetBudgetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBudgetRequest, GetBudgetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAlertRulesResponse> listAlertRules(ListAlertRulesRequest request, AsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse> handler) {
        LOG.trace("Called async listAlertRules");
        ListAlertRulesRequest interceptedRequest = ListAlertRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlertRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlertRulesResponse> transformer = ListAlertRulesConverter.fromResponse();
        AsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAlertRulesRequest, ListAlertRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBudgetsResponse> listBudgets(ListBudgetsRequest request, AsyncHandler<ListBudgetsRequest, ListBudgetsResponse> handler) {
        LOG.trace("Called async listBudgets");
        ListBudgetsRequest interceptedRequest = ListBudgetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBudgetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBudgetsResponse> transformer = ListBudgetsConverter.fromResponse();
        AsyncHandler<ListBudgetsRequest, ListBudgetsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBudgetsRequest, ListBudgetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAlertRuleResponse> updateAlertRule(UpdateAlertRuleRequest request, AsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse> handler) {
        LOG.trace("Called async updateAlertRule");
        UpdateAlertRuleRequest interceptedRequest = UpdateAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAlertRuleResponse> transformer = UpdateAlertRuleConverter.fromResponse();
        AsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAlertRuleRequest, UpdateAlertRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest request, AsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse> handler) {
        LOG.trace("Called async updateBudget");
        UpdateBudgetRequest interceptedRequest = UpdateBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBudgetResponse> transformer = UpdateBudgetConverter.fromResponse();
        AsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBudgetRequest, UpdateBudgetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BudgetAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BudgetAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new BudgetAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

