/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.budget.model.LifecycleState;
import com.oracle.bmc.budget.model.SortBy;
import com.oracle.bmc.budget.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListBudgetsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private LifecycleState lifecycleState;
    private String displayName;
    private TargetType targetType;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "sortOrder", "sortBy", "lifecycleState", "displayName", "targetType", "opcRequestId"})
    ListBudgetsRequest(String compartmentId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, LifecycleState lifecycleState, String displayName, TargetType targetType, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.targetType = targetType;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBudgetsRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private LifecycleState lifecycleState;
        private String displayName;
        private TargetType targetType;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBudgetsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.targetType(o.getTargetType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBudgetsRequest build() {
            ListBudgetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListBudgetsRequest buildWithoutInvocationCallback() {
            return new ListBudgetsRequest(this.compartmentId, this.limit, this.page, this.sortOrder, this.sortBy, this.lifecycleState, this.displayName, this.targetType, this.opcRequestId);
        }

        public String toString() {
            return "ListBudgetsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ", targetType=" + (Object)((Object)this.targetType) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum TargetType {
        All("ALL"),
        Compartment("COMPARTMENT"),
        Tag("TAG");

        private final String value;
        private static Map<String, TargetType> map;

        private TargetType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TargetType: " + key);
        }

        static {
            map = new HashMap<String, TargetType>();
            for (TargetType v : TargetType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

