/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.cims.IncidentAsync;
import com.oracle.bmc.cims.internal.http.CreateIncidentConverter;
import com.oracle.bmc.cims.internal.http.GetIncidentConverter;
import com.oracle.bmc.cims.internal.http.GetStatusConverter;
import com.oracle.bmc.cims.internal.http.ListIncidentResourceTypesConverter;
import com.oracle.bmc.cims.internal.http.ListIncidentsConverter;
import com.oracle.bmc.cims.internal.http.UpdateIncidentConverter;
import com.oracle.bmc.cims.internal.http.ValidateUserConverter;
import com.oracle.bmc.cims.requests.CreateIncidentRequest;
import com.oracle.bmc.cims.requests.GetIncidentRequest;
import com.oracle.bmc.cims.requests.GetStatusRequest;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.requests.UpdateIncidentRequest;
import com.oracle.bmc.cims.requests.ValidateUserRequest;
import com.oracle.bmc.cims.responses.CreateIncidentResponse;
import com.oracle.bmc.cims.responses.GetIncidentResponse;
import com.oracle.bmc.cims.responses.GetStatusResponse;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.cims.responses.UpdateIncidentResponse;
import com.oracle.bmc.cims.responses.ValidateUserResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncidentAsyncClient
implements IncidentAsync {
    private static final Logger LOG = LoggerFactory.getLogger(IncidentAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INCIDENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://incidentmanagement.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateIncidentResponse> createIncident(CreateIncidentRequest request, AsyncHandler<CreateIncidentRequest, CreateIncidentResponse> handler) {
        LOG.trace("Called async createIncident");
        CreateIncidentRequest interceptedRequest = CreateIncidentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIncidentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateIncidentResponse> transformer = CreateIncidentConverter.fromResponse();
        AsyncHandler<CreateIncidentRequest, CreateIncidentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateIncidentRequest, CreateIncidentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetIncidentResponse> getIncident(GetIncidentRequest request, AsyncHandler<GetIncidentRequest, GetIncidentResponse> handler) {
        LOG.trace("Called async getIncident");
        GetIncidentRequest interceptedRequest = GetIncidentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIncidentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIncidentResponse> transformer = GetIncidentConverter.fromResponse();
        AsyncHandler<GetIncidentRequest, GetIncidentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetIncidentRequest, GetIncidentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStatusResponse> getStatus(GetStatusRequest request, AsyncHandler<GetStatusRequest, GetStatusResponse> handler) {
        LOG.trace("Called async getStatus");
        GetStatusRequest interceptedRequest = GetStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStatusResponse> transformer = GetStatusConverter.fromResponse();
        AsyncHandler<GetStatusRequest, GetStatusResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStatusRequest, GetStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListIncidentResourceTypesResponse> listIncidentResourceTypes(ListIncidentResourceTypesRequest request, AsyncHandler<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse> handler) {
        LOG.trace("Called async listIncidentResourceTypes");
        ListIncidentResourceTypesRequest interceptedRequest = ListIncidentResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIncidentResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIncidentResourceTypesResponse> transformer = ListIncidentResourceTypesConverter.fromResponse();
        AsyncHandler<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListIncidentsResponse> listIncidents(ListIncidentsRequest request, AsyncHandler<ListIncidentsRequest, ListIncidentsResponse> handler) {
        LOG.trace("Called async listIncidents");
        ListIncidentsRequest interceptedRequest = ListIncidentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIncidentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIncidentsResponse> transformer = ListIncidentsConverter.fromResponse();
        AsyncHandler<ListIncidentsRequest, ListIncidentsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListIncidentsRequest, ListIncidentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateIncidentResponse> updateIncident(UpdateIncidentRequest request, AsyncHandler<UpdateIncidentRequest, UpdateIncidentResponse> handler) {
        LOG.trace("Called async updateIncident");
        UpdateIncidentRequest interceptedRequest = UpdateIncidentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIncidentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIncidentResponse> transformer = UpdateIncidentConverter.fromResponse();
        AsyncHandler<UpdateIncidentRequest, UpdateIncidentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateIncidentRequest, UpdateIncidentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateUserResponse> validateUser(ValidateUserRequest request, AsyncHandler<ValidateUserRequest, ValidateUserResponse> handler) {
        LOG.trace("Called async validateUser");
        ValidateUserRequest interceptedRequest = ValidateUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateUserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateUserResponse> transformer = ValidateUserConverter.fromResponse();
        AsyncHandler<ValidateUserRequest, ValidateUserResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateUserRequest, ValidateUserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IncidentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public IncidentAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new IncidentAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

