/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.cims.Incident;
import com.oracle.bmc.cims.model.IncidentResourceType;
import com.oracle.bmc.cims.model.IncidentSummary;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class IncidentPaginators {
    private final Incident client;

    public Iterable<ListIncidentResourceTypesResponse> listIncidentResourceTypesResponseIterator(final ListIncidentResourceTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIncidentResourceTypesRequest.Builder>(){

            public ListIncidentResourceTypesRequest.Builder get() {
                return ListIncidentResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, String>(){

            public String apply(ListIncidentResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder>, ListIncidentResourceTypesRequest>(){

            public ListIncidentResourceTypesRequest apply(RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse>(){

            public ListIncidentResourceTypesResponse apply(ListIncidentResourceTypesRequest request) {
                return IncidentPaginators.this.client.listIncidentResourceTypes(request);
            }
        });
    }

    public Iterable<IncidentResourceType> listIncidentResourceTypesRecordIterator(final ListIncidentResourceTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIncidentResourceTypesRequest.Builder>(){

            public ListIncidentResourceTypesRequest.Builder get() {
                return ListIncidentResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, String>(){

            public String apply(ListIncidentResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder>, ListIncidentResourceTypesRequest>(){

            public ListIncidentResourceTypesRequest apply(RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse>(){

            public ListIncidentResourceTypesResponse apply(ListIncidentResourceTypesRequest request) {
                return IncidentPaginators.this.client.listIncidentResourceTypes(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, List<IncidentResourceType>>(){

            public List<IncidentResourceType> apply(ListIncidentResourceTypesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIncidentsResponse> listIncidentsResponseIterator(final ListIncidentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIncidentsRequest.Builder>(){

            public ListIncidentsRequest.Builder get() {
                return ListIncidentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentsResponse, String>(){

            public String apply(ListIncidentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentsRequest.Builder>, ListIncidentsRequest>(){

            public ListIncidentsRequest apply(RequestBuilderAndToken<ListIncidentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIncidentsRequest, ListIncidentsResponse>(){

            public ListIncidentsResponse apply(ListIncidentsRequest request) {
                return IncidentPaginators.this.client.listIncidents(request);
            }
        });
    }

    public Iterable<IncidentSummary> listIncidentsRecordIterator(final ListIncidentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIncidentsRequest.Builder>(){

            public ListIncidentsRequest.Builder get() {
                return ListIncidentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentsResponse, String>(){

            public String apply(ListIncidentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentsRequest.Builder>, ListIncidentsRequest>(){

            public ListIncidentsRequest apply(RequestBuilderAndToken<ListIncidentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIncidentsRequest, ListIncidentsResponse>(){

            public ListIncidentsResponse apply(ListIncidentsRequest request) {
                return IncidentPaginators.this.client.listIncidents(request);
            }
        }, (Function)new Function<ListIncidentsResponse, List<IncidentSummary>>(){

            public List<IncidentSummary> apply(ListIncidentsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public IncidentPaginators(Incident client) {
        this.client = client;
    }
}

