/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.Category;
import com.oracle.bmc.cims.model.IssueType;
import com.oracle.bmc.cims.model.Item;
import com.oracle.bmc.cims.model.SubCategory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ActivityItem
extends Item {
    @JsonProperty(value="comments")
    private final String comments;
    @JsonProperty(value="timeCreated")
    private final Integer timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Integer timeUpdated;
    @JsonProperty(value="activityType")
    private final ActivityType activityType;
    @JsonProperty(value="activityAuthor")
    private final ActivityAuthor activityAuthor;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ActivityItem(String itemKey, String name, Category category, SubCategory subCategory, IssueType issueType, String comments, Integer timeCreated, Integer timeUpdated, ActivityType activityType, ActivityAuthor activityAuthor) {
        super(itemKey, name, category, subCategory, issueType);
        this.comments = comments;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.activityType = activityType;
        this.activityAuthor = activityAuthor;
    }

    public Builder toBuilder() {
        return new Builder().comments(this.comments).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).activityType(this.activityType).activityAuthor(this.activityAuthor);
    }

    public String getComments() {
        return this.comments;
    }

    public Integer getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getTimeUpdated() {
        return this.timeUpdated;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public ActivityAuthor getActivityAuthor() {
        return this.activityAuthor;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "ActivityItem(super=" + super.toString() + ", comments=" + this.getComments() + ", timeCreated=" + this.getTimeCreated() + ", timeUpdated=" + this.getTimeUpdated() + ", activityType=" + (Object)((Object)this.getActivityType()) + ", activityAuthor=" + (Object)((Object)this.getActivityAuthor()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityItem)) {
            return false;
        }
        ActivityItem other = (ActivityItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$timeCreated = this.getTimeCreated();
        Integer other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Integer this$timeUpdated = this.getTimeUpdated();
        Integer other$timeUpdated = other.getTimeUpdated();
        if (this$timeUpdated == null ? other$timeUpdated != null : !((Object)this$timeUpdated).equals(other$timeUpdated)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        ActivityType this$activityType = this.getActivityType();
        ActivityType other$activityType = other.getActivityType();
        if (this$activityType == null ? other$activityType != null : !((Object)((Object)this$activityType)).equals((Object)other$activityType)) {
            return false;
        }
        ActivityAuthor this$activityAuthor = this.getActivityAuthor();
        ActivityAuthor other$activityAuthor = other.getActivityAuthor();
        if (this$activityAuthor == null ? other$activityAuthor != null : !((Object)((Object)this$activityAuthor)).equals((Object)other$activityAuthor)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ActivityItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Integer $timeUpdated = this.getTimeUpdated();
        result = result * 59 + ($timeUpdated == null ? 43 : ((Object)$timeUpdated).hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        ActivityType $activityType = this.getActivityType();
        result = result * 59 + ($activityType == null ? 43 : ((Object)((Object)$activityType)).hashCode());
        ActivityAuthor $activityAuthor = this.getActivityAuthor();
        result = result * 59 + ($activityAuthor == null ? 43 : ((Object)((Object)$activityAuthor)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum ActivityAuthor {
        Customer("CUSTOMER"),
        Oracle("ORACLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActivityAuthor> map;

        private ActivityAuthor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActivityAuthor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActivityAuthor', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActivityAuthor.class);
            map = new HashMap<String, ActivityAuthor>();
            for (ActivityAuthor v : ActivityAuthor.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ActivityType {
        Notes("NOTES"),
        ProblemDescription("PROBLEM_DESCRIPTION"),
        Update("UPDATE"),
        Close("CLOSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActivityType> map;

        private ActivityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActivityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActivityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActivityType.class);
            map = new HashMap<String, ActivityType>();
            for (ActivityType v : ActivityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="itemKey")
        private String itemKey;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="subCategory")
        private SubCategory subCategory;
        @JsonProperty(value="issueType")
        private IssueType issueType;
        @JsonProperty(value="comments")
        private String comments;
        @JsonProperty(value="timeCreated")
        private Integer timeCreated;
        @JsonProperty(value="timeUpdated")
        private Integer timeUpdated;
        @JsonProperty(value="activityType")
        private ActivityType activityType;
        @JsonProperty(value="activityAuthor")
        private ActivityAuthor activityAuthor;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder itemKey(String itemKey) {
            this.itemKey = itemKey;
            this.__explicitlySet__.add("itemKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            this.__explicitlySet__.add("subCategory");
            return this;
        }

        public Builder issueType(IssueType issueType) {
            this.issueType = issueType;
            this.__explicitlySet__.add("issueType");
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            this.__explicitlySet__.add("comments");
            return this;
        }

        public Builder timeCreated(Integer timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Integer timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            this.__explicitlySet__.add("activityType");
            return this;
        }

        public Builder activityAuthor(ActivityAuthor activityAuthor) {
            this.activityAuthor = activityAuthor;
            this.__explicitlySet__.add("activityAuthor");
            return this;
        }

        public ActivityItem build() {
            ActivityItem __instance__ = new ActivityItem(this.itemKey, this.name, this.category, this.subCategory, this.issueType, this.comments, this.timeCreated, this.timeUpdated, this.activityType, this.activityAuthor);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ActivityItem o) {
            Builder copiedBuilder = this.itemKey(o.getItemKey()).name(o.getName()).category(o.getCategory()).subCategory(o.getSubCategory()).issueType(o.getIssueType()).comments(o.getComments()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).activityType(o.getActivityType()).activityAuthor(o.getActivityAuthor());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "ActivityItem.Builder(comments=" + this.comments + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", activityType=" + (Object)((Object)this.activityType) + ", activityAuthor=" + (Object)((Object)this.activityAuthor) + ")";
        }
    }
}

