/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.cloudguard.CloudGuardAsync;
import com.oracle.bmc.cloudguard.internal.http.ChangeDetectorRecipeCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.ChangeManagedListCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.ChangeResponderRecipeCompartmentConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.CreateTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.DeleteTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.ExecuteResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.GetConditionMetadataTypeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetConfigurationConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.GetProblemConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.GetTargetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.ListConditionMetadataTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRecipeDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListDetectorsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListImpactedResourcesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListManagedListTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListManagedListsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListProblemHistoriesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResourceTypesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderActivitiesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRecipeResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetDetectorRecipeDetectorRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetDetectorRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetResponderRecipeResponderRulesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetResponderRecipesConverter;
import com.oracle.bmc.cloudguard.internal.http.ListTargetsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestRiskScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSecurityScoreSummarizedTrendConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedActivityProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedRiskScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendProblemsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendResponderExecutionsConverter;
import com.oracle.bmc.cloudguard.internal.http.RequestSummarizedTrendSecurityScoresConverter;
import com.oracle.bmc.cloudguard.internal.http.SkipBulkResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.SkipResponderExecutionConverter;
import com.oracle.bmc.cloudguard.internal.http.TriggerResponderConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateBulkProblemStatusConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateConfigurationConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateManagedListConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateProblemStatusConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetDetectorRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetDetectorRecipeDetectorRuleConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetResponderRecipeConverter;
import com.oracle.bmc.cloudguard.internal.http.UpdateTargetResponderRecipeResponderRuleConverter;
import com.oracle.bmc.cloudguard.requests.ChangeDetectorRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeManagedListCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeResponderRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.CreateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.CreateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteManagedListRequest;
import com.oracle.bmc.cloudguard.requests.DeleteResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.ExecuteResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetConditionMetadataTypeRequest;
import com.oracle.bmc.cloudguard.requests.GetConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetManagedListRequest;
import com.oracle.bmc.cloudguard.requests.GetProblemRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.ListConditionMetadataTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorsRequest;
import com.oracle.bmc.cloudguard.requests.ListImpactedResourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListsRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemHistoriesRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemsRequest;
import com.oracle.bmc.cloudguard.requests.ListRecommendationsRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderActivitiesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetsRequest;
import com.oracle.bmc.cloudguard.requests.RequestRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoreSummarizedTrendRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedActivityProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.SkipBulkResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.SkipResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.TriggerResponderRequest;
import com.oracle.bmc.cloudguard.requests.UpdateBulkProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.UpdateProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.responses.ChangeDetectorRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeManagedListCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeResponderRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.CreateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.CreateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteManagedListResponse;
import com.oracle.bmc.cloudguard.responses.DeleteResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponse;
import com.oracle.bmc.cloudguard.responses.ExecuteResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetConditionMetadataTypeResponse;
import com.oracle.bmc.cloudguard.responses.GetConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetManagedListResponse;
import com.oracle.bmc.cloudguard.responses.GetProblemResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponse;
import com.oracle.bmc.cloudguard.responses.ListConditionMetadataTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorsResponse;
import com.oracle.bmc.cloudguard.responses.ListImpactedResourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListsResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemHistoriesResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemsResponse;
import com.oracle.bmc.cloudguard.responses.ListRecommendationsResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderActivitiesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetsResponse;
import com.oracle.bmc.cloudguard.responses.RequestRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoreSummarizedTrendResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedActivityProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.SkipBulkResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.SkipResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.TriggerResponderResponse;
import com.oracle.bmc.cloudguard.responses.UpdateBulkProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.UpdateProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudGuardAsyncClient
implements CloudGuardAsync {
    private static final Logger LOG = LoggerFactory.getLogger(CloudGuardAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CLOUDGUARD").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudguard-cp-api.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public CloudGuardAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public CloudGuardAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public CloudGuardAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public CloudGuardAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public CloudGuardAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public CloudGuardAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public CloudGuardAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public CloudGuardAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeDetectorRecipeCompartmentResponse> changeDetectorRecipeCompartment(ChangeDetectorRecipeCompartmentRequest request, AsyncHandler<ChangeDetectorRecipeCompartmentRequest, ChangeDetectorRecipeCompartmentResponse> handler) {
        LOG.trace("Called async changeDetectorRecipeCompartment");
        ChangeDetectorRecipeCompartmentRequest interceptedRequest = ChangeDetectorRecipeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDetectorRecipeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeDetectorRecipeCompartmentResponse> transformer = ChangeDetectorRecipeCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeDetectorRecipeCompartmentRequest, ChangeDetectorRecipeCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDetectorRecipeCompartmentRequest, ChangeDetectorRecipeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeManagedListCompartmentResponse> changeManagedListCompartment(ChangeManagedListCompartmentRequest request, AsyncHandler<ChangeManagedListCompartmentRequest, ChangeManagedListCompartmentResponse> handler) {
        LOG.trace("Called async changeManagedListCompartment");
        ChangeManagedListCompartmentRequest interceptedRequest = ChangeManagedListCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeManagedListCompartmentResponse> transformer = ChangeManagedListCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeManagedListCompartmentRequest, ChangeManagedListCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeManagedListCompartmentRequest, ChangeManagedListCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeResponderRecipeCompartmentResponse> changeResponderRecipeCompartment(ChangeResponderRecipeCompartmentRequest request, AsyncHandler<ChangeResponderRecipeCompartmentRequest, ChangeResponderRecipeCompartmentResponse> handler) {
        LOG.trace("Called async changeResponderRecipeCompartment");
        ChangeResponderRecipeCompartmentRequest interceptedRequest = ChangeResponderRecipeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeResponderRecipeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeResponderRecipeCompartmentResponse> transformer = ChangeResponderRecipeCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeResponderRecipeCompartmentRequest, ChangeResponderRecipeCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeResponderRecipeCompartmentRequest, ChangeResponderRecipeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDetectorRecipeResponse> createDetectorRecipe(CreateDetectorRecipeRequest request, AsyncHandler<CreateDetectorRecipeRequest, CreateDetectorRecipeResponse> handler) {
        LOG.trace("Called async createDetectorRecipe");
        CreateDetectorRecipeRequest interceptedRequest = CreateDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDetectorRecipeResponse> transformer = CreateDetectorRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDetectorRecipeRequest, CreateDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDetectorRecipeRequest, CreateDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateManagedListResponse> createManagedList(CreateManagedListRequest request, AsyncHandler<CreateManagedListRequest, CreateManagedListResponse> handler) {
        LOG.trace("Called async createManagedList");
        CreateManagedListRequest interceptedRequest = CreateManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateManagedListResponse> transformer = CreateManagedListConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateManagedListRequest, CreateManagedListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateManagedListRequest, CreateManagedListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateResponderRecipeResponse> createResponderRecipe(CreateResponderRecipeRequest request, AsyncHandler<CreateResponderRecipeRequest, CreateResponderRecipeResponse> handler) {
        LOG.trace("Called async createResponderRecipe");
        CreateResponderRecipeRequest interceptedRequest = CreateResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateResponderRecipeResponse> transformer = CreateResponderRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateResponderRecipeRequest, CreateResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateResponderRecipeRequest, CreateResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTargetResponse> createTarget(CreateTargetRequest request, AsyncHandler<CreateTargetRequest, CreateTargetResponse> handler) {
        LOG.trace("Called async createTarget");
        CreateTargetRequest interceptedRequest = CreateTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTargetResponse> transformer = CreateTargetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTargetRequest, CreateTargetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTargetRequest, CreateTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTargetDetectorRecipeResponse> createTargetDetectorRecipe(CreateTargetDetectorRecipeRequest request, AsyncHandler<CreateTargetDetectorRecipeRequest, CreateTargetDetectorRecipeResponse> handler) {
        LOG.trace("Called async createTargetDetectorRecipe");
        CreateTargetDetectorRecipeRequest interceptedRequest = CreateTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTargetDetectorRecipeResponse> transformer = CreateTargetDetectorRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTargetDetectorRecipeRequest, CreateTargetDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTargetDetectorRecipeRequest, CreateTargetDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTargetResponderRecipeResponse> createTargetResponderRecipe(CreateTargetResponderRecipeRequest request, AsyncHandler<CreateTargetResponderRecipeRequest, CreateTargetResponderRecipeResponse> handler) {
        LOG.trace("Called async createTargetResponderRecipe");
        CreateTargetResponderRecipeRequest interceptedRequest = CreateTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTargetResponderRecipeResponse> transformer = CreateTargetResponderRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTargetResponderRecipeRequest, CreateTargetResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTargetResponderRecipeRequest, CreateTargetResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDetectorRecipeResponse> deleteDetectorRecipe(DeleteDetectorRecipeRequest request, AsyncHandler<DeleteDetectorRecipeRequest, DeleteDetectorRecipeResponse> handler) {
        LOG.trace("Called async deleteDetectorRecipe");
        DeleteDetectorRecipeRequest interceptedRequest = DeleteDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDetectorRecipeResponse> transformer = DeleteDetectorRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteDetectorRecipeRequest, DeleteDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDetectorRecipeRequest, DeleteDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteManagedListResponse> deleteManagedList(DeleteManagedListRequest request, AsyncHandler<DeleteManagedListRequest, DeleteManagedListResponse> handler) {
        LOG.trace("Called async deleteManagedList");
        DeleteManagedListRequest interceptedRequest = DeleteManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteManagedListResponse> transformer = DeleteManagedListConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteManagedListRequest, DeleteManagedListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteManagedListRequest, DeleteManagedListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteResponderRecipeResponse> deleteResponderRecipe(DeleteResponderRecipeRequest request, AsyncHandler<DeleteResponderRecipeRequest, DeleteResponderRecipeResponse> handler) {
        LOG.trace("Called async deleteResponderRecipe");
        DeleteResponderRecipeRequest interceptedRequest = DeleteResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteResponderRecipeResponse> transformer = DeleteResponderRecipeConverter.fromResponse();
        AsyncHandler<DeleteResponderRecipeRequest, DeleteResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteResponderRecipeRequest, DeleteResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTargetResponse> deleteTarget(DeleteTargetRequest request, AsyncHandler<DeleteTargetRequest, DeleteTargetResponse> handler) {
        LOG.trace("Called async deleteTarget");
        DeleteTargetRequest interceptedRequest = DeleteTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTargetResponse> transformer = DeleteTargetConverter.fromResponse();
        AsyncHandler<DeleteTargetRequest, DeleteTargetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTargetRequest, DeleteTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTargetDetectorRecipeResponse> deleteTargetDetectorRecipe(DeleteTargetDetectorRecipeRequest request, AsyncHandler<DeleteTargetDetectorRecipeRequest, DeleteTargetDetectorRecipeResponse> handler) {
        LOG.trace("Called async deleteTargetDetectorRecipe");
        DeleteTargetDetectorRecipeRequest interceptedRequest = DeleteTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTargetDetectorRecipeResponse> transformer = DeleteTargetDetectorRecipeConverter.fromResponse();
        AsyncHandler<DeleteTargetDetectorRecipeRequest, DeleteTargetDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTargetDetectorRecipeRequest, DeleteTargetDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTargetResponderRecipeResponse> deleteTargetResponderRecipe(DeleteTargetResponderRecipeRequest request, AsyncHandler<DeleteTargetResponderRecipeRequest, DeleteTargetResponderRecipeResponse> handler) {
        LOG.trace("Called async deleteTargetResponderRecipe");
        DeleteTargetResponderRecipeRequest interceptedRequest = DeleteTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTargetResponderRecipeResponse> transformer = DeleteTargetResponderRecipeConverter.fromResponse();
        AsyncHandler<DeleteTargetResponderRecipeRequest, DeleteTargetResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTargetResponderRecipeRequest, DeleteTargetResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExecuteResponderExecutionResponse> executeResponderExecution(ExecuteResponderExecutionRequest request, AsyncHandler<ExecuteResponderExecutionRequest, ExecuteResponderExecutionResponse> handler) {
        LOG.trace("Called async executeResponderExecution");
        ExecuteResponderExecutionRequest interceptedRequest = ExecuteResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExecuteResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExecuteResponderExecutionResponse> transformer = ExecuteResponderExecutionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExecuteResponderExecutionRequest, ExecuteResponderExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExecuteResponderExecutionRequest, ExecuteResponderExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConditionMetadataTypeResponse> getConditionMetadataType(GetConditionMetadataTypeRequest request, AsyncHandler<GetConditionMetadataTypeRequest, GetConditionMetadataTypeResponse> handler) {
        LOG.trace("Called async getConditionMetadataType");
        GetConditionMetadataTypeRequest interceptedRequest = GetConditionMetadataTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConditionMetadataTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConditionMetadataTypeResponse> transformer = GetConditionMetadataTypeConverter.fromResponse();
        AsyncHandler<GetConditionMetadataTypeRequest, GetConditionMetadataTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConditionMetadataTypeRequest, GetConditionMetadataTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        LOG.trace("Called async getConfiguration");
        GetConfigurationRequest interceptedRequest = GetConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigurationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConfigurationResponse> transformer = GetConfigurationConverter.fromResponse();
        AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConfigurationRequest, GetConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDetectorResponse> getDetector(GetDetectorRequest request, AsyncHandler<GetDetectorRequest, GetDetectorResponse> handler) {
        LOG.trace("Called async getDetector");
        GetDetectorRequest interceptedRequest = GetDetectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDetectorResponse> transformer = GetDetectorConverter.fromResponse();
        AsyncHandler<GetDetectorRequest, GetDetectorResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDetectorRequest, GetDetectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDetectorRecipeResponse> getDetectorRecipe(GetDetectorRecipeRequest request, AsyncHandler<GetDetectorRecipeRequest, GetDetectorRecipeResponse> handler) {
        LOG.trace("Called async getDetectorRecipe");
        GetDetectorRecipeRequest interceptedRequest = GetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDetectorRecipeResponse> transformer = GetDetectorRecipeConverter.fromResponse();
        AsyncHandler<GetDetectorRecipeRequest, GetDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDetectorRecipeRequest, GetDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDetectorRecipeDetectorRuleResponse> getDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, AsyncHandler<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> handler) {
        LOG.trace("Called async getDetectorRecipeDetectorRule");
        GetDetectorRecipeDetectorRuleRequest interceptedRequest = GetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDetectorRecipeDetectorRuleResponse> transformer = GetDetectorRecipeDetectorRuleConverter.fromResponse();
        AsyncHandler<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDetectorRuleResponse> getDetectorRule(GetDetectorRuleRequest request, AsyncHandler<GetDetectorRuleRequest, GetDetectorRuleResponse> handler) {
        LOG.trace("Called async getDetectorRule");
        GetDetectorRuleRequest interceptedRequest = GetDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDetectorRuleResponse> transformer = GetDetectorRuleConverter.fromResponse();
        AsyncHandler<GetDetectorRuleRequest, GetDetectorRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDetectorRuleRequest, GetDetectorRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagedListResponse> getManagedList(GetManagedListRequest request, AsyncHandler<GetManagedListRequest, GetManagedListResponse> handler) {
        LOG.trace("Called async getManagedList");
        GetManagedListRequest interceptedRequest = GetManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetManagedListResponse> transformer = GetManagedListConverter.fromResponse();
        AsyncHandler<GetManagedListRequest, GetManagedListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagedListRequest, GetManagedListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProblemResponse> getProblem(GetProblemRequest request, AsyncHandler<GetProblemRequest, GetProblemResponse> handler) {
        LOG.trace("Called async getProblem");
        GetProblemRequest interceptedRequest = GetProblemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProblemConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProblemResponse> transformer = GetProblemConverter.fromResponse();
        AsyncHandler<GetProblemRequest, GetProblemResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProblemRequest, GetProblemResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResponderExecutionResponse> getResponderExecution(GetResponderExecutionRequest request, AsyncHandler<GetResponderExecutionRequest, GetResponderExecutionResponse> handler) {
        LOG.trace("Called async getResponderExecution");
        GetResponderExecutionRequest interceptedRequest = GetResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetResponderExecutionResponse> transformer = GetResponderExecutionConverter.fromResponse();
        AsyncHandler<GetResponderExecutionRequest, GetResponderExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResponderExecutionRequest, GetResponderExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResponderRecipeResponse> getResponderRecipe(GetResponderRecipeRequest request, AsyncHandler<GetResponderRecipeRequest, GetResponderRecipeResponse> handler) {
        LOG.trace("Called async getResponderRecipe");
        GetResponderRecipeRequest interceptedRequest = GetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetResponderRecipeResponse> transformer = GetResponderRecipeConverter.fromResponse();
        AsyncHandler<GetResponderRecipeRequest, GetResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResponderRecipeRequest, GetResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResponderRecipeResponderRuleResponse> getResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, AsyncHandler<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> handler) {
        LOG.trace("Called async getResponderRecipeResponderRule");
        GetResponderRecipeResponderRuleRequest interceptedRequest = GetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetResponderRecipeResponderRuleResponse> transformer = GetResponderRecipeResponderRuleConverter.fromResponse();
        AsyncHandler<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResponderRuleResponse> getResponderRule(GetResponderRuleRequest request, AsyncHandler<GetResponderRuleRequest, GetResponderRuleResponse> handler) {
        LOG.trace("Called async getResponderRule");
        GetResponderRuleRequest interceptedRequest = GetResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetResponderRuleResponse> transformer = GetResponderRuleConverter.fromResponse();
        AsyncHandler<GetResponderRuleRequest, GetResponderRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResponderRuleRequest, GetResponderRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTargetResponse> getTarget(GetTargetRequest request, AsyncHandler<GetTargetRequest, GetTargetResponse> handler) {
        LOG.trace("Called async getTarget");
        GetTargetRequest interceptedRequest = GetTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTargetResponse> transformer = GetTargetConverter.fromResponse();
        AsyncHandler<GetTargetRequest, GetTargetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTargetRequest, GetTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTargetDetectorRecipeResponse> getTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, AsyncHandler<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> handler) {
        LOG.trace("Called async getTargetDetectorRecipe");
        GetTargetDetectorRecipeRequest interceptedRequest = GetTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTargetDetectorRecipeResponse> transformer = GetTargetDetectorRecipeConverter.fromResponse();
        AsyncHandler<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTargetDetectorRecipeDetectorRuleResponse> getTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, AsyncHandler<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> handler) {
        LOG.trace("Called async getTargetDetectorRecipeDetectorRule");
        GetTargetDetectorRecipeDetectorRuleRequest interceptedRequest = GetTargetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTargetDetectorRecipeDetectorRuleResponse> transformer = GetTargetDetectorRecipeDetectorRuleConverter.fromResponse();
        AsyncHandler<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTargetResponderRecipeResponse> getTargetResponderRecipe(GetTargetResponderRecipeRequest request, AsyncHandler<GetTargetResponderRecipeRequest, GetTargetResponderRecipeResponse> handler) {
        LOG.trace("Called async getTargetResponderRecipe");
        GetTargetResponderRecipeRequest interceptedRequest = GetTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTargetResponderRecipeResponse> transformer = GetTargetResponderRecipeConverter.fromResponse();
        AsyncHandler<GetTargetResponderRecipeRequest, GetTargetResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTargetResponderRecipeRequest, GetTargetResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTargetResponderRecipeResponderRuleResponse> getTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, AsyncHandler<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> handler) {
        LOG.trace("Called async getTargetResponderRecipeResponderRule");
        GetTargetResponderRecipeResponderRuleRequest interceptedRequest = GetTargetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTargetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTargetResponderRecipeResponderRuleResponse> transformer = GetTargetResponderRecipeResponderRuleConverter.fromResponse();
        AsyncHandler<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConditionMetadataTypesResponse> listConditionMetadataTypes(ListConditionMetadataTypesRequest request, AsyncHandler<ListConditionMetadataTypesRequest, ListConditionMetadataTypesResponse> handler) {
        LOG.trace("Called async listConditionMetadataTypes");
        ListConditionMetadataTypesRequest interceptedRequest = ListConditionMetadataTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConditionMetadataTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConditionMetadataTypesResponse> transformer = ListConditionMetadataTypesConverter.fromResponse();
        AsyncHandler<ListConditionMetadataTypesRequest, ListConditionMetadataTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConditionMetadataTypesRequest, ListConditionMetadataTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDetectorRecipeDetectorRulesResponse> listDetectorRecipeDetectorRules(ListDetectorRecipeDetectorRulesRequest request, AsyncHandler<ListDetectorRecipeDetectorRulesRequest, ListDetectorRecipeDetectorRulesResponse> handler) {
        LOG.trace("Called async listDetectorRecipeDetectorRules");
        ListDetectorRecipeDetectorRulesRequest interceptedRequest = ListDetectorRecipeDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRecipeDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDetectorRecipeDetectorRulesResponse> transformer = ListDetectorRecipeDetectorRulesConverter.fromResponse();
        AsyncHandler<ListDetectorRecipeDetectorRulesRequest, ListDetectorRecipeDetectorRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDetectorRecipeDetectorRulesRequest, ListDetectorRecipeDetectorRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDetectorRecipesResponse> listDetectorRecipes(ListDetectorRecipesRequest request, AsyncHandler<ListDetectorRecipesRequest, ListDetectorRecipesResponse> handler) {
        LOG.trace("Called async listDetectorRecipes");
        ListDetectorRecipesRequest interceptedRequest = ListDetectorRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRecipesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDetectorRecipesResponse> transformer = ListDetectorRecipesConverter.fromResponse();
        AsyncHandler<ListDetectorRecipesRequest, ListDetectorRecipesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDetectorRecipesRequest, ListDetectorRecipesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDetectorRulesResponse> listDetectorRules(ListDetectorRulesRequest request, AsyncHandler<ListDetectorRulesRequest, ListDetectorRulesResponse> handler) {
        LOG.trace("Called async listDetectorRules");
        ListDetectorRulesRequest interceptedRequest = ListDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDetectorRulesResponse> transformer = ListDetectorRulesConverter.fromResponse();
        AsyncHandler<ListDetectorRulesRequest, ListDetectorRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDetectorRulesRequest, ListDetectorRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDetectorsResponse> listDetectors(ListDetectorsRequest request, AsyncHandler<ListDetectorsRequest, ListDetectorsResponse> handler) {
        LOG.trace("Called async listDetectors");
        ListDetectorsRequest interceptedRequest = ListDetectorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDetectorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDetectorsResponse> transformer = ListDetectorsConverter.fromResponse();
        AsyncHandler<ListDetectorsRequest, ListDetectorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDetectorsRequest, ListDetectorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListImpactedResourcesResponse> listImpactedResources(ListImpactedResourcesRequest request, AsyncHandler<ListImpactedResourcesRequest, ListImpactedResourcesResponse> handler) {
        LOG.trace("Called async listImpactedResources");
        ListImpactedResourcesRequest interceptedRequest = ListImpactedResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListImpactedResourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListImpactedResourcesResponse> transformer = ListImpactedResourcesConverter.fromResponse();
        AsyncHandler<ListImpactedResourcesRequest, ListImpactedResourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListImpactedResourcesRequest, ListImpactedResourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedListTypesResponse> listManagedListTypes(ListManagedListTypesRequest request, AsyncHandler<ListManagedListTypesRequest, ListManagedListTypesResponse> handler) {
        LOG.trace("Called async listManagedListTypes");
        ListManagedListTypesRequest interceptedRequest = ListManagedListTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedListTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListManagedListTypesResponse> transformer = ListManagedListTypesConverter.fromResponse();
        AsyncHandler<ListManagedListTypesRequest, ListManagedListTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedListTypesRequest, ListManagedListTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedListsResponse> listManagedLists(ListManagedListsRequest request, AsyncHandler<ListManagedListsRequest, ListManagedListsResponse> handler) {
        LOG.trace("Called async listManagedLists");
        ListManagedListsRequest interceptedRequest = ListManagedListsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedListsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListManagedListsResponse> transformer = ListManagedListsConverter.fromResponse();
        AsyncHandler<ListManagedListsRequest, ListManagedListsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedListsRequest, ListManagedListsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProblemHistoriesResponse> listProblemHistories(ListProblemHistoriesRequest request, AsyncHandler<ListProblemHistoriesRequest, ListProblemHistoriesResponse> handler) {
        LOG.trace("Called async listProblemHistories");
        ListProblemHistoriesRequest interceptedRequest = ListProblemHistoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProblemHistoriesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProblemHistoriesResponse> transformer = ListProblemHistoriesConverter.fromResponse();
        AsyncHandler<ListProblemHistoriesRequest, ListProblemHistoriesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProblemHistoriesRequest, ListProblemHistoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProblemsResponse> listProblems(ListProblemsRequest request, AsyncHandler<ListProblemsRequest, ListProblemsResponse> handler) {
        LOG.trace("Called async listProblems");
        ListProblemsRequest interceptedRequest = ListProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProblemsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProblemsResponse> transformer = ListProblemsConverter.fromResponse();
        AsyncHandler<ListProblemsRequest, ListProblemsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProblemsRequest, ListProblemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest request, AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handler) {
        LOG.trace("Called async listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecommendationsRequest, ListRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request, AsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handler) {
        LOG.trace("Called async listResourceTypes");
        ListResourceTypesRequest interceptedRequest = ListResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResourceTypesResponse> transformer = ListResourceTypesConverter.fromResponse();
        AsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResourceTypesRequest, ListResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResponderActivitiesResponse> listResponderActivities(ListResponderActivitiesRequest request, AsyncHandler<ListResponderActivitiesRequest, ListResponderActivitiesResponse> handler) {
        LOG.trace("Called async listResponderActivities");
        ListResponderActivitiesRequest interceptedRequest = ListResponderActivitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderActivitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResponderActivitiesResponse> transformer = ListResponderActivitiesConverter.fromResponse();
        AsyncHandler<ListResponderActivitiesRequest, ListResponderActivitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResponderActivitiesRequest, ListResponderActivitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResponderExecutionsResponse> listResponderExecutions(ListResponderExecutionsRequest request, AsyncHandler<ListResponderExecutionsRequest, ListResponderExecutionsResponse> handler) {
        LOG.trace("Called async listResponderExecutions");
        ListResponderExecutionsRequest interceptedRequest = ListResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResponderExecutionsResponse> transformer = ListResponderExecutionsConverter.fromResponse();
        AsyncHandler<ListResponderExecutionsRequest, ListResponderExecutionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResponderExecutionsRequest, ListResponderExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResponderRecipeResponderRulesResponse> listResponderRecipeResponderRules(ListResponderRecipeResponderRulesRequest request, AsyncHandler<ListResponderRecipeResponderRulesRequest, ListResponderRecipeResponderRulesResponse> handler) {
        LOG.trace("Called async listResponderRecipeResponderRules");
        ListResponderRecipeResponderRulesRequest interceptedRequest = ListResponderRecipeResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRecipeResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResponderRecipeResponderRulesResponse> transformer = ListResponderRecipeResponderRulesConverter.fromResponse();
        AsyncHandler<ListResponderRecipeResponderRulesRequest, ListResponderRecipeResponderRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResponderRecipeResponderRulesRequest, ListResponderRecipeResponderRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResponderRecipesResponse> listResponderRecipes(ListResponderRecipesRequest request, AsyncHandler<ListResponderRecipesRequest, ListResponderRecipesResponse> handler) {
        LOG.trace("Called async listResponderRecipes");
        ListResponderRecipesRequest interceptedRequest = ListResponderRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRecipesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResponderRecipesResponse> transformer = ListResponderRecipesConverter.fromResponse();
        AsyncHandler<ListResponderRecipesRequest, ListResponderRecipesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResponderRecipesRequest, ListResponderRecipesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResponderRulesResponse> listResponderRules(ListResponderRulesRequest request, AsyncHandler<ListResponderRulesRequest, ListResponderRulesResponse> handler) {
        LOG.trace("Called async listResponderRules");
        ListResponderRulesRequest interceptedRequest = ListResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListResponderRulesResponse> transformer = ListResponderRulesConverter.fromResponse();
        AsyncHandler<ListResponderRulesRequest, ListResponderRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResponderRulesRequest, ListResponderRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTargetDetectorRecipeDetectorRulesResponse> listTargetDetectorRecipeDetectorRules(ListTargetDetectorRecipeDetectorRulesRequest request, AsyncHandler<ListTargetDetectorRecipeDetectorRulesRequest, ListTargetDetectorRecipeDetectorRulesResponse> handler) {
        LOG.trace("Called async listTargetDetectorRecipeDetectorRules");
        ListTargetDetectorRecipeDetectorRulesRequest interceptedRequest = ListTargetDetectorRecipeDetectorRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetDetectorRecipeDetectorRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTargetDetectorRecipeDetectorRulesResponse> transformer = ListTargetDetectorRecipeDetectorRulesConverter.fromResponse();
        AsyncHandler<ListTargetDetectorRecipeDetectorRulesRequest, ListTargetDetectorRecipeDetectorRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTargetDetectorRecipeDetectorRulesRequest, ListTargetDetectorRecipeDetectorRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTargetDetectorRecipesResponse> listTargetDetectorRecipes(ListTargetDetectorRecipesRequest request, AsyncHandler<ListTargetDetectorRecipesRequest, ListTargetDetectorRecipesResponse> handler) {
        LOG.trace("Called async listTargetDetectorRecipes");
        ListTargetDetectorRecipesRequest interceptedRequest = ListTargetDetectorRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetDetectorRecipesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTargetDetectorRecipesResponse> transformer = ListTargetDetectorRecipesConverter.fromResponse();
        AsyncHandler<ListTargetDetectorRecipesRequest, ListTargetDetectorRecipesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTargetDetectorRecipesRequest, ListTargetDetectorRecipesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTargetResponderRecipeResponderRulesResponse> listTargetResponderRecipeResponderRules(ListTargetResponderRecipeResponderRulesRequest request, AsyncHandler<ListTargetResponderRecipeResponderRulesRequest, ListTargetResponderRecipeResponderRulesResponse> handler) {
        LOG.trace("Called async listTargetResponderRecipeResponderRules");
        ListTargetResponderRecipeResponderRulesRequest interceptedRequest = ListTargetResponderRecipeResponderRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetResponderRecipeResponderRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTargetResponderRecipeResponderRulesResponse> transformer = ListTargetResponderRecipeResponderRulesConverter.fromResponse();
        AsyncHandler<ListTargetResponderRecipeResponderRulesRequest, ListTargetResponderRecipeResponderRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTargetResponderRecipeResponderRulesRequest, ListTargetResponderRecipeResponderRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTargetResponderRecipesResponse> listTargetResponderRecipes(ListTargetResponderRecipesRequest request, AsyncHandler<ListTargetResponderRecipesRequest, ListTargetResponderRecipesResponse> handler) {
        LOG.trace("Called async listTargetResponderRecipes");
        ListTargetResponderRecipesRequest interceptedRequest = ListTargetResponderRecipesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetResponderRecipesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTargetResponderRecipesResponse> transformer = ListTargetResponderRecipesConverter.fromResponse();
        AsyncHandler<ListTargetResponderRecipesRequest, ListTargetResponderRecipesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTargetResponderRecipesRequest, ListTargetResponderRecipesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTargetsResponse> listTargets(ListTargetsRequest request, AsyncHandler<ListTargetsRequest, ListTargetsResponse> handler) {
        LOG.trace("Called async listTargets");
        ListTargetsRequest interceptedRequest = ListTargetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTargetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTargetsResponse> transformer = ListTargetsConverter.fromResponse();
        AsyncHandler<ListTargetsRequest, ListTargetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTargetsRequest, ListTargetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestRiskScoresResponse> requestRiskScores(RequestRiskScoresRequest request, AsyncHandler<RequestRiskScoresRequest, RequestRiskScoresResponse> handler) {
        LOG.trace("Called async requestRiskScores");
        RequestRiskScoresRequest interceptedRequest = RequestRiskScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestRiskScoresConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestRiskScoresResponse> transformer = RequestRiskScoresConverter.fromResponse();
        AsyncHandler<RequestRiskScoresRequest, RequestRiskScoresResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestRiskScoresRequest, RequestRiskScoresResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSecurityScoreSummarizedTrendResponse> requestSecurityScoreSummarizedTrend(RequestSecurityScoreSummarizedTrendRequest request, AsyncHandler<RequestSecurityScoreSummarizedTrendRequest, RequestSecurityScoreSummarizedTrendResponse> handler) {
        LOG.trace("Called async requestSecurityScoreSummarizedTrend");
        RequestSecurityScoreSummarizedTrendRequest interceptedRequest = RequestSecurityScoreSummarizedTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSecurityScoreSummarizedTrendConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSecurityScoreSummarizedTrendResponse> transformer = RequestSecurityScoreSummarizedTrendConverter.fromResponse();
        AsyncHandler<RequestSecurityScoreSummarizedTrendRequest, RequestSecurityScoreSummarizedTrendResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSecurityScoreSummarizedTrendRequest, RequestSecurityScoreSummarizedTrendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSecurityScoresResponse> requestSecurityScores(RequestSecurityScoresRequest request, AsyncHandler<RequestSecurityScoresRequest, RequestSecurityScoresResponse> handler) {
        LOG.trace("Called async requestSecurityScores");
        RequestSecurityScoresRequest interceptedRequest = RequestSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSecurityScoresResponse> transformer = RequestSecurityScoresConverter.fromResponse();
        AsyncHandler<RequestSecurityScoresRequest, RequestSecurityScoresResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSecurityScoresRequest, RequestSecurityScoresResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedActivityProblemsResponse> requestSummarizedActivityProblems(RequestSummarizedActivityProblemsRequest request, AsyncHandler<RequestSummarizedActivityProblemsRequest, RequestSummarizedActivityProblemsResponse> handler) {
        LOG.trace("Called async requestSummarizedActivityProblems");
        RequestSummarizedActivityProblemsRequest interceptedRequest = RequestSummarizedActivityProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedActivityProblemsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedActivityProblemsResponse> transformer = RequestSummarizedActivityProblemsConverter.fromResponse();
        AsyncHandler<RequestSummarizedActivityProblemsRequest, RequestSummarizedActivityProblemsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedActivityProblemsRequest, RequestSummarizedActivityProblemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedProblemsResponse> requestSummarizedProblems(RequestSummarizedProblemsRequest request, AsyncHandler<RequestSummarizedProblemsRequest, RequestSummarizedProblemsResponse> handler) {
        LOG.trace("Called async requestSummarizedProblems");
        RequestSummarizedProblemsRequest interceptedRequest = RequestSummarizedProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedProblemsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedProblemsResponse> transformer = RequestSummarizedProblemsConverter.fromResponse();
        AsyncHandler<RequestSummarizedProblemsRequest, RequestSummarizedProblemsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedProblemsRequest, RequestSummarizedProblemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedResponderExecutionsResponse> requestSummarizedResponderExecutions(RequestSummarizedResponderExecutionsRequest request, AsyncHandler<RequestSummarizedResponderExecutionsRequest, RequestSummarizedResponderExecutionsResponse> handler) {
        LOG.trace("Called async requestSummarizedResponderExecutions");
        RequestSummarizedResponderExecutionsRequest interceptedRequest = RequestSummarizedResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedResponderExecutionsResponse> transformer = RequestSummarizedResponderExecutionsConverter.fromResponse();
        AsyncHandler<RequestSummarizedResponderExecutionsRequest, RequestSummarizedResponderExecutionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedResponderExecutionsRequest, RequestSummarizedResponderExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedRiskScoresResponse> requestSummarizedRiskScores(RequestSummarizedRiskScoresRequest request, AsyncHandler<RequestSummarizedRiskScoresRequest, RequestSummarizedRiskScoresResponse> handler) {
        LOG.trace("Called async requestSummarizedRiskScores");
        RequestSummarizedRiskScoresRequest interceptedRequest = RequestSummarizedRiskScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedRiskScoresConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedRiskScoresResponse> transformer = RequestSummarizedRiskScoresConverter.fromResponse();
        AsyncHandler<RequestSummarizedRiskScoresRequest, RequestSummarizedRiskScoresResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedRiskScoresRequest, RequestSummarizedRiskScoresResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedSecurityScoresResponse> requestSummarizedSecurityScores(RequestSummarizedSecurityScoresRequest request, AsyncHandler<RequestSummarizedSecurityScoresRequest, RequestSummarizedSecurityScoresResponse> handler) {
        LOG.trace("Called async requestSummarizedSecurityScores");
        RequestSummarizedSecurityScoresRequest interceptedRequest = RequestSummarizedSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedSecurityScoresResponse> transformer = RequestSummarizedSecurityScoresConverter.fromResponse();
        AsyncHandler<RequestSummarizedSecurityScoresRequest, RequestSummarizedSecurityScoresResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedSecurityScoresRequest, RequestSummarizedSecurityScoresResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedTrendProblemsResponse> requestSummarizedTrendProblems(RequestSummarizedTrendProblemsRequest request, AsyncHandler<RequestSummarizedTrendProblemsRequest, RequestSummarizedTrendProblemsResponse> handler) {
        LOG.trace("Called async requestSummarizedTrendProblems");
        RequestSummarizedTrendProblemsRequest interceptedRequest = RequestSummarizedTrendProblemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendProblemsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedTrendProblemsResponse> transformer = RequestSummarizedTrendProblemsConverter.fromResponse();
        AsyncHandler<RequestSummarizedTrendProblemsRequest, RequestSummarizedTrendProblemsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedTrendProblemsRequest, RequestSummarizedTrendProblemsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedTrendResponderExecutionsResponse> requestSummarizedTrendResponderExecutions(RequestSummarizedTrendResponderExecutionsRequest request, AsyncHandler<RequestSummarizedTrendResponderExecutionsRequest, RequestSummarizedTrendResponderExecutionsResponse> handler) {
        LOG.trace("Called async requestSummarizedTrendResponderExecutions");
        RequestSummarizedTrendResponderExecutionsRequest interceptedRequest = RequestSummarizedTrendResponderExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendResponderExecutionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedTrendResponderExecutionsResponse> transformer = RequestSummarizedTrendResponderExecutionsConverter.fromResponse();
        AsyncHandler<RequestSummarizedTrendResponderExecutionsRequest, RequestSummarizedTrendResponderExecutionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedTrendResponderExecutionsRequest, RequestSummarizedTrendResponderExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedTrendSecurityScoresResponse> requestSummarizedTrendSecurityScores(RequestSummarizedTrendSecurityScoresRequest request, AsyncHandler<RequestSummarizedTrendSecurityScoresRequest, RequestSummarizedTrendSecurityScoresResponse> handler) {
        LOG.trace("Called async requestSummarizedTrendSecurityScores");
        RequestSummarizedTrendSecurityScoresRequest interceptedRequest = RequestSummarizedTrendSecurityScoresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedTrendSecurityScoresConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RequestSummarizedTrendSecurityScoresResponse> transformer = RequestSummarizedTrendSecurityScoresConverter.fromResponse();
        AsyncHandler<RequestSummarizedTrendSecurityScoresRequest, RequestSummarizedTrendSecurityScoresResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedTrendSecurityScoresRequest, RequestSummarizedTrendSecurityScoresResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SkipBulkResponderExecutionResponse> skipBulkResponderExecution(SkipBulkResponderExecutionRequest request, AsyncHandler<SkipBulkResponderExecutionRequest, SkipBulkResponderExecutionResponse> handler) {
        LOG.trace("Called async skipBulkResponderExecution");
        SkipBulkResponderExecutionRequest interceptedRequest = SkipBulkResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipBulkResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, SkipBulkResponderExecutionResponse> transformer = SkipBulkResponderExecutionConverter.fromResponse();
        AsyncHandler<SkipBulkResponderExecutionRequest, SkipBulkResponderExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SkipBulkResponderExecutionRequest, SkipBulkResponderExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SkipResponderExecutionResponse> skipResponderExecution(SkipResponderExecutionRequest request, AsyncHandler<SkipResponderExecutionRequest, SkipResponderExecutionResponse> handler) {
        LOG.trace("Called async skipResponderExecution");
        SkipResponderExecutionRequest interceptedRequest = SkipResponderExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipResponderExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, SkipResponderExecutionResponse> transformer = SkipResponderExecutionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<SkipResponderExecutionRequest, SkipResponderExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SkipResponderExecutionRequest, SkipResponderExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<TriggerResponderResponse> triggerResponder(TriggerResponderRequest request, AsyncHandler<TriggerResponderRequest, TriggerResponderResponse> handler) {
        LOG.trace("Called async triggerResponder");
        TriggerResponderRequest interceptedRequest = TriggerResponderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TriggerResponderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, TriggerResponderResponse> transformer = TriggerResponderConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<TriggerResponderRequest, TriggerResponderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<TriggerResponderRequest, TriggerResponderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBulkProblemStatusResponse> updateBulkProblemStatus(UpdateBulkProblemStatusRequest request, AsyncHandler<UpdateBulkProblemStatusRequest, UpdateBulkProblemStatusResponse> handler) {
        LOG.trace("Called async updateBulkProblemStatus");
        UpdateBulkProblemStatusRequest interceptedRequest = UpdateBulkProblemStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBulkProblemStatusConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBulkProblemStatusResponse> transformer = UpdateBulkProblemStatusConverter.fromResponse();
        AsyncHandler<UpdateBulkProblemStatusRequest, UpdateBulkProblemStatusResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBulkProblemStatusRequest, UpdateBulkProblemStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        LOG.trace("Called async updateConfiguration");
        UpdateConfigurationRequest interceptedRequest = UpdateConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConfigurationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateConfigurationResponse> transformer = UpdateConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConfigurationRequest, UpdateConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDetectorRecipeResponse> updateDetectorRecipe(UpdateDetectorRecipeRequest request, AsyncHandler<UpdateDetectorRecipeRequest, UpdateDetectorRecipeResponse> handler) {
        LOG.trace("Called async updateDetectorRecipe");
        UpdateDetectorRecipeRequest interceptedRequest = UpdateDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDetectorRecipeResponse> transformer = UpdateDetectorRecipeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateDetectorRecipeRequest, UpdateDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDetectorRecipeRequest, UpdateDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDetectorRecipeDetectorRuleResponse> updateDetectorRecipeDetectorRule(UpdateDetectorRecipeDetectorRuleRequest request, AsyncHandler<UpdateDetectorRecipeDetectorRuleRequest, UpdateDetectorRecipeDetectorRuleResponse> handler) {
        LOG.trace("Called async updateDetectorRecipeDetectorRule");
        UpdateDetectorRecipeDetectorRuleRequest interceptedRequest = UpdateDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDetectorRecipeDetectorRuleResponse> transformer = UpdateDetectorRecipeDetectorRuleConverter.fromResponse();
        AsyncHandler<UpdateDetectorRecipeDetectorRuleRequest, UpdateDetectorRecipeDetectorRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDetectorRecipeDetectorRuleRequest, UpdateDetectorRecipeDetectorRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagedListResponse> updateManagedList(UpdateManagedListRequest request, AsyncHandler<UpdateManagedListRequest, UpdateManagedListResponse> handler) {
        LOG.trace("Called async updateManagedList");
        UpdateManagedListRequest interceptedRequest = UpdateManagedListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateManagedListResponse> transformer = UpdateManagedListConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateManagedListRequest, UpdateManagedListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagedListRequest, UpdateManagedListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProblemStatusResponse> updateProblemStatus(UpdateProblemStatusRequest request, AsyncHandler<UpdateProblemStatusRequest, UpdateProblemStatusResponse> handler) {
        LOG.trace("Called async updateProblemStatus");
        UpdateProblemStatusRequest interceptedRequest = UpdateProblemStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProblemStatusConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProblemStatusResponse> transformer = UpdateProblemStatusConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateProblemStatusRequest, UpdateProblemStatusResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProblemStatusRequest, UpdateProblemStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateResponderRecipeResponse> updateResponderRecipe(UpdateResponderRecipeRequest request, AsyncHandler<UpdateResponderRecipeRequest, UpdateResponderRecipeResponse> handler) {
        LOG.trace("Called async updateResponderRecipe");
        UpdateResponderRecipeRequest interceptedRequest = UpdateResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateResponderRecipeResponse> transformer = UpdateResponderRecipeConverter.fromResponse();
        AsyncHandler<UpdateResponderRecipeRequest, UpdateResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateResponderRecipeRequest, UpdateResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateResponderRecipeResponderRuleResponse> updateResponderRecipeResponderRule(UpdateResponderRecipeResponderRuleRequest request, AsyncHandler<UpdateResponderRecipeResponderRuleRequest, UpdateResponderRecipeResponderRuleResponse> handler) {
        LOG.trace("Called async updateResponderRecipeResponderRule");
        UpdateResponderRecipeResponderRuleRequest interceptedRequest = UpdateResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateResponderRecipeResponderRuleResponse> transformer = UpdateResponderRecipeResponderRuleConverter.fromResponse();
        AsyncHandler<UpdateResponderRecipeResponderRuleRequest, UpdateResponderRecipeResponderRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateResponderRecipeResponderRuleRequest, UpdateResponderRecipeResponderRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTargetResponse> updateTarget(UpdateTargetRequest request, AsyncHandler<UpdateTargetRequest, UpdateTargetResponse> handler) {
        LOG.trace("Called async updateTarget");
        UpdateTargetRequest interceptedRequest = UpdateTargetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTargetResponse> transformer = UpdateTargetConverter.fromResponse();
        AsyncHandler<UpdateTargetRequest, UpdateTargetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTargetRequest, UpdateTargetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTargetDetectorRecipeResponse> updateTargetDetectorRecipe(UpdateTargetDetectorRecipeRequest request, AsyncHandler<UpdateTargetDetectorRecipeRequest, UpdateTargetDetectorRecipeResponse> handler) {
        LOG.trace("Called async updateTargetDetectorRecipe");
        UpdateTargetDetectorRecipeRequest interceptedRequest = UpdateTargetDetectorRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetDetectorRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTargetDetectorRecipeResponse> transformer = UpdateTargetDetectorRecipeConverter.fromResponse();
        AsyncHandler<UpdateTargetDetectorRecipeRequest, UpdateTargetDetectorRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTargetDetectorRecipeRequest, UpdateTargetDetectorRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTargetDetectorRecipeDetectorRuleResponse> updateTargetDetectorRecipeDetectorRule(UpdateTargetDetectorRecipeDetectorRuleRequest request, AsyncHandler<UpdateTargetDetectorRecipeDetectorRuleRequest, UpdateTargetDetectorRecipeDetectorRuleResponse> handler) {
        LOG.trace("Called async updateTargetDetectorRecipeDetectorRule");
        UpdateTargetDetectorRecipeDetectorRuleRequest interceptedRequest = UpdateTargetDetectorRecipeDetectorRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetDetectorRecipeDetectorRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTargetDetectorRecipeDetectorRuleResponse> transformer = UpdateTargetDetectorRecipeDetectorRuleConverter.fromResponse();
        AsyncHandler<UpdateTargetDetectorRecipeDetectorRuleRequest, UpdateTargetDetectorRecipeDetectorRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTargetDetectorRecipeDetectorRuleRequest, UpdateTargetDetectorRecipeDetectorRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTargetResponderRecipeResponse> updateTargetResponderRecipe(UpdateTargetResponderRecipeRequest request, AsyncHandler<UpdateTargetResponderRecipeRequest, UpdateTargetResponderRecipeResponse> handler) {
        LOG.trace("Called async updateTargetResponderRecipe");
        UpdateTargetResponderRecipeRequest interceptedRequest = UpdateTargetResponderRecipeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetResponderRecipeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTargetResponderRecipeResponse> transformer = UpdateTargetResponderRecipeConverter.fromResponse();
        AsyncHandler<UpdateTargetResponderRecipeRequest, UpdateTargetResponderRecipeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTargetResponderRecipeRequest, UpdateTargetResponderRecipeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTargetResponderRecipeResponderRuleResponse> updateTargetResponderRecipeResponderRule(UpdateTargetResponderRecipeResponderRuleRequest request, AsyncHandler<UpdateTargetResponderRecipeResponderRuleRequest, UpdateTargetResponderRecipeResponderRuleResponse> handler) {
        LOG.trace("Called async updateTargetResponderRecipeResponderRule");
        UpdateTargetResponderRecipeResponderRuleRequest interceptedRequest = UpdateTargetResponderRecipeResponderRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTargetResponderRecipeResponderRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTargetResponderRecipeResponderRuleResponse> transformer = UpdateTargetResponderRecipeResponderRuleConverter.fromResponse();
        AsyncHandler<UpdateTargetResponderRecipeResponderRuleRequest, UpdateTargetResponderRecipeResponderRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTargetResponderRecipeResponderRuleRequest, UpdateTargetResponderRecipeResponderRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CloudGuardAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public CloudGuardAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new CloudGuardAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

