/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.TargetResponderRecipeCollection;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipesRequest;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTargetResponderRecipesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTargetResponderRecipesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTargetResponderRecipesRequest interceptRequest(ListTargetResponderRecipesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTargetResponderRecipesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("targets").path(HttpUtils.encodePathSegment((String)request.getTargetId())).path("targetResponderRecipes");
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTargetResponderRecipesResponse> fromResponse() {
        Function<Response, ListTargetResponderRecipesResponse> transformer = new Function<Response, ListTargetResponderRecipesResponse>(){

            public ListTargetResponderRecipesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TargetResponderRecipeCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTargetResponderRecipesResponse.Builder builder = ListTargetResponderRecipesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.targetResponderRecipeCollection((TargetResponderRecipeCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListTargetResponderRecipesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

