/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.ProblemAggregationCollection;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedProblemsRequest;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedProblemsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummarizedProblemsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSummarizedProblemsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RequestSummarizedProblemsRequest interceptRequest(RequestSummarizedProblemsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RequestSummarizedProblemsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull(request.getListDimensions(), (String)"listDimensions is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("problems").path("actions").path("summarize");
        target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"listDimensions", request.getListDimensions(), (CollectionFormatType)CollectionFormatType.Multi);
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getCompartmentIdInSubtree() != null) {
            target = target.queryParam("compartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentIdInSubtree())});
        }
        if (request.getAccessLevel() != null) {
            target = target.queryParam("accessLevel", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAccessLevel().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RequestSummarizedProblemsResponse> fromResponse() {
        Function<Response, RequestSummarizedProblemsResponse> transformer = new Function<Response, RequestSummarizedProblemsResponse>(){

            public RequestSummarizedProblemsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.RequestSummarizedProblemsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ProblemAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RequestSummarizedProblemsResponse.Builder builder = RequestSummarizedProblemsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.problemAggregationCollection((ProblemAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                RequestSummarizedProblemsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

