/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDetectorRecipeRequest
extends BmcRequest<Void> {
    private String detectorRecipeId;
    private String opcRequestId;

    @ConstructorProperties(value={"detectorRecipeId", "opcRequestId"})
    GetDetectorRecipeRequest(String detectorRecipeId, String opcRequestId) {
        this.detectorRecipeId = detectorRecipeId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDetectorRecipeId() {
        return this.detectorRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDetectorRecipeRequest, Void> {
        private String detectorRecipeId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDetectorRecipeRequest o) {
            this.detectorRecipeId(o.getDetectorRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDetectorRecipeRequest build() {
            GetDetectorRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder detectorRecipeId(String detectorRecipeId) {
            this.detectorRecipeId = detectorRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDetectorRecipeRequest buildWithoutInvocationCallback() {
            return new GetDetectorRecipeRequest(this.detectorRecipeId, this.opcRequestId);
        }

        public String toString() {
            return "GetDetectorRecipeRequest.Builder(detectorRecipeId=" + this.detectorRecipeId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

