/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.cloudguard.model.RecommendationLifecycleDetail;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListRecommendationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String targetId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private LifecycleState lifecycleState;
    private RecommendationLifecycleDetail lifecycleDetail;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "sortOrder", "sortBy", "targetId", "compartmentIdInSubtree", "accessLevel", "lifecycleState", "lifecycleDetail", "limit", "page", "opcRequestId"})
    ListRecommendationsRequest(String compartmentId, SortOrders sortOrder, SortBy sortBy, String targetId, Boolean compartmentIdInSubtree, AccessLevel accessLevel, LifecycleState lifecycleState, RecommendationLifecycleDetail lifecycleDetail, Integer limit, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.targetId = targetId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetail = lifecycleDetail;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public RecommendationLifecycleDetail getLifecycleDetail() {
        return this.lifecycleDetail;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecommendationsRequest, Void> {
        private String compartmentId;
        private SortOrders sortOrder;
        private SortBy sortBy;
        private String targetId;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private LifecycleState lifecycleState;
        private RecommendationLifecycleDetail lifecycleDetail;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecommendationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.targetId(o.getTargetId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.lifecycleState(o.getLifecycleState());
            this.lifecycleDetail(o.getLifecycleDetail());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecommendationsRequest build() {
            ListRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleDetail(RecommendationLifecycleDetail lifecycleDetail) {
            this.lifecycleDetail = lifecycleDetail;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListRecommendationsRequest buildWithoutInvocationCallback() {
            return new ListRecommendationsRequest(this.compartmentId, this.sortOrder, this.sortBy, this.targetId, this.compartmentIdInSubtree, this.accessLevel, this.lifecycleState, this.lifecycleDetail, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListRecommendationsRequest.Builder(compartmentId=" + this.compartmentId + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", targetId=" + this.targetId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleDetail=" + (Object)((Object)this.lifecycleDetail) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        RiskLevel("riskLevel"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

