/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.ResponderExecutionModes;
import com.oracle.bmc.cloudguard.model.ResponderExecutionStates;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListResponderExecutionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private List<String> responderRuleIds;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThanOrEqualTo;
    private Date timeCompletedGreaterThanOrEqualTo;
    private Date timeCompletedLessThanOrEqualTo;
    private String targetId;
    private String resourceType;
    private ResponderType responderType;
    private ResponderExecutionStates responderExecutionStatus;
    private ResponderExecutionModes responderExecutionMode;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "compartmentIdInSubtree", "accessLevel", "responderRuleIds", "timeCreatedGreaterThanOrEqualTo", "timeCreatedLessThanOrEqualTo", "timeCompletedGreaterThanOrEqualTo", "timeCompletedLessThanOrEqualTo", "targetId", "resourceType", "responderType", "responderExecutionStatus", "responderExecutionMode", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListResponderExecutionsRequest(String compartmentId, Boolean compartmentIdInSubtree, AccessLevel accessLevel, List<String> responderRuleIds, Date timeCreatedGreaterThanOrEqualTo, Date timeCreatedLessThanOrEqualTo, Date timeCompletedGreaterThanOrEqualTo, Date timeCompletedLessThanOrEqualTo, String targetId, String resourceType, ResponderType responderType, ResponderExecutionStates responderExecutionStatus, ResponderExecutionModes responderExecutionMode, Integer limit, String page, SortOrders sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.responderRuleIds = responderRuleIds;
        this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
        this.timeCreatedLessThanOrEqualTo = timeCreatedLessThanOrEqualTo;
        this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
        this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
        this.targetId = targetId;
        this.resourceType = resourceType;
        this.responderType = responderType;
        this.responderExecutionStatus = responderExecutionStatus;
        this.responderExecutionMode = responderExecutionMode;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public List<String> getResponderRuleIds() {
        return this.responderRuleIds;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThanOrEqualTo() {
        return this.timeCreatedLessThanOrEqualTo;
    }

    public Date getTimeCompletedGreaterThanOrEqualTo() {
        return this.timeCompletedGreaterThanOrEqualTo;
    }

    public Date getTimeCompletedLessThanOrEqualTo() {
        return this.timeCompletedLessThanOrEqualTo;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResponderType getResponderType() {
        return this.responderType;
    }

    public ResponderExecutionStates getResponderExecutionStatus() {
        return this.responderExecutionStatus;
    }

    public ResponderExecutionModes getResponderExecutionMode() {
        return this.responderExecutionMode;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResponderExecutionsRequest, Void> {
        private String compartmentId;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private List<String> responderRuleIds;
        private Date timeCreatedGreaterThanOrEqualTo;
        private Date timeCreatedLessThanOrEqualTo;
        private Date timeCompletedGreaterThanOrEqualTo;
        private Date timeCompletedLessThanOrEqualTo;
        private String targetId;
        private String resourceType;
        private ResponderType responderType;
        private ResponderExecutionStates responderExecutionStatus;
        private ResponderExecutionModes responderExecutionMode;
        private Integer limit;
        private String page;
        private SortOrders sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResponderExecutionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.responderRuleIds(o.getResponderRuleIds());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThanOrEqualTo(o.getTimeCreatedLessThanOrEqualTo());
            this.timeCompletedGreaterThanOrEqualTo(o.getTimeCompletedGreaterThanOrEqualTo());
            this.timeCompletedLessThanOrEqualTo(o.getTimeCompletedLessThanOrEqualTo());
            this.targetId(o.getTargetId());
            this.resourceType(o.getResourceType());
            this.responderType(o.getResponderType());
            this.responderExecutionStatus(o.getResponderExecutionStatus());
            this.responderExecutionMode(o.getResponderExecutionMode());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResponderExecutionsRequest build() {
            ListResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder responderRuleIds(List<String> responderRuleIds) {
            this.responderRuleIds = responderRuleIds;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThanOrEqualTo(Date timeCreatedLessThanOrEqualTo) {
            this.timeCreatedLessThanOrEqualTo = timeCreatedLessThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedGreaterThanOrEqualTo(Date timeCompletedGreaterThanOrEqualTo) {
            this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedLessThanOrEqualTo(Date timeCompletedLessThanOrEqualTo) {
            this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder responderType(ResponderType responderType) {
            this.responderType = responderType;
            return this;
        }

        public Builder responderExecutionStatus(ResponderExecutionStates responderExecutionStatus) {
            this.responderExecutionStatus = responderExecutionStatus;
            return this;
        }

        public Builder responderExecutionMode(ResponderExecutionModes responderExecutionMode) {
            this.responderExecutionMode = responderExecutionMode;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListResponderExecutionsRequest buildWithoutInvocationCallback() {
            return new ListResponderExecutionsRequest(this.compartmentId, this.compartmentIdInSubtree, this.accessLevel, this.responderRuleIds, this.timeCreatedGreaterThanOrEqualTo, this.timeCreatedLessThanOrEqualTo, this.timeCompletedGreaterThanOrEqualTo, this.timeCompletedLessThanOrEqualTo, this.targetId, this.resourceType, this.responderType, this.responderExecutionStatus, this.responderExecutionMode, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListResponderExecutionsRequest.Builder(compartmentId=" + this.compartmentId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", responderRuleIds=" + this.responderRuleIds + ", timeCreatedGreaterThanOrEqualTo=" + this.timeCreatedGreaterThanOrEqualTo + ", timeCreatedLessThanOrEqualTo=" + this.timeCreatedLessThanOrEqualTo + ", timeCompletedGreaterThanOrEqualTo=" + this.timeCompletedGreaterThanOrEqualTo + ", timeCompletedLessThanOrEqualTo=" + this.timeCompletedLessThanOrEqualTo + ", targetId=" + this.targetId + ", resourceType=" + this.resourceType + ", responderType=" + (Object)((Object)this.responderType) + ", responderExecutionStatus=" + (Object)((Object)this.responderExecutionStatus) + ", responderExecutionMode=" + (Object)((Object)this.responderExecutionMode) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        ResponderRuleName("responderRuleName"),
        ResourceName("resourceName"),
        TimeCompleted("timeCompleted");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResponderType {
        Remediation("REMEDIATION"),
        Notification("NOTIFICATION");

        private final String value;
        private static Map<String, ResponderType> map;

        private ResponderType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResponderType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ResponderType: " + key);
        }

        static {
            map = new HashMap<String, ResponderType>();
            for (ResponderType v : ResponderType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

