/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class RequestSummarizedActivityProblemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private Boolean includeUnknownLocations;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "compartmentIdInSubtree", "accessLevel", "limit", "includeUnknownLocations", "page", "opcRequestId"})
    RequestSummarizedActivityProblemsRequest(String compartmentId, Boolean compartmentIdInSubtree, AccessLevel accessLevel, Integer limit, Boolean includeUnknownLocations, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.limit = limit;
        this.includeUnknownLocations = includeUnknownLocations;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIncludeUnknownLocations() {
        return this.includeUnknownLocations;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedActivityProblemsRequest, Void> {
        private String compartmentId;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private Integer limit;
        private Boolean includeUnknownLocations;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedActivityProblemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.includeUnknownLocations(o.getIncludeUnknownLocations());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedActivityProblemsRequest build() {
            RequestSummarizedActivityProblemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder includeUnknownLocations(Boolean includeUnknownLocations) {
            this.includeUnknownLocations = includeUnknownLocations;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RequestSummarizedActivityProblemsRequest buildWithoutInvocationCallback() {
            return new RequestSummarizedActivityProblemsRequest(this.compartmentId, this.compartmentIdInSubtree, this.accessLevel, this.limit, this.includeUnknownLocations, this.page, this.opcRequestId);
        }

        public String toString() {
            return "RequestSummarizedActivityProblemsRequest.Builder(compartmentId=" + this.compartmentId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", limit=" + this.limit + ", includeUnknownLocations=" + this.includeUnknownLocations + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

