/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import java.util.UUID;

public class RetryTokenUtils {
    private static final String OPC_RETRY_TOKEN_HEADER = "opc-retry-token";

    private RetryTokenUtils() {
    }

    public static void addRetryToken(WrappedInvocationBuilder ib) {
        boolean isOpcRetryTokenAlreadySet = ib.getHeaders().containsKey((Object)OPC_RETRY_TOKEN_HEADER);
        if (isOpcRetryTokenAlreadySet) {
            return;
        }
        ib.header(OPC_RETRY_TOKEN_HEADER, RetryTokenUtils.generateRetryToken());
    }

    private static String generateRetryToken() {
        return UUID.randomUUID().toString();
    }
}

