/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import com.oracle.bmc.http.signing.internal.RequestSignerImpl;
import java.beans.ConstructorProperties;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;

public class DefaultRequestSignerFactory
implements RequestSignerFactory {
    private final SigningStrategy signingStrategy;

    @Override
    public RequestSigner createRequestSigner(Service service, AbstractAuthenticationDetailsProvider abstractAuthProvider) {
        if (!(abstractAuthProvider instanceof BasicAuthenticationDetailsProvider)) {
            throw new IllegalArgumentException("Unsupported auth provider type: " + abstractAuthProvider.getClass().getName());
        }
        BasicAuthenticationDetailsProvider authProvider = (BasicAuthenticationDetailsProvider)abstractAuthProvider;
        AuthCachingPolicy policy = DefaultRequestSignerFactory.getAuthCachingPolicy(authProvider);
        Supplier<String> keyIdSupplier = DefaultRequestSignerFactory.createKeyIdSupplier(authProvider, policy);
        KeySupplier<RSAPrivateKey> keySupplier = DefaultRequestSignerFactory.createKeySupplier(authProvider, policy);
        return new RequestSignerImpl(keySupplier, this.signingStrategy, keyIdSupplier);
    }

    private static Supplier<String> createKeyIdSupplier(final BasicAuthenticationDetailsProvider authenticationDetailsProvider, AuthCachingPolicy policy) {
        boolean cacheKeyId = true;
        if (policy != null) {
            cacheKeyId = policy.cacheKeyId();
        }
        if (!cacheKeyId) {
            return new Supplier<String>(){

                public String get() {
                    return authenticationDetailsProvider.getKeyId();
                }
            };
        }
        final String keyId = authenticationDetailsProvider.getKeyId();
        return new Supplier<String>(){

            public String get() {
                return keyId;
            }
        };
    }

    private static KeySupplier<RSAPrivateKey> createKeySupplier(final BasicAuthenticationDetailsProvider authenticationDetailsProvider, AuthCachingPolicy policy) {
        boolean cachePrivateKey = true;
        if (policy != null) {
            cachePrivateKey = policy.cachePrivateKey();
        }
        if (!cachePrivateKey) {
            return new KeySupplier<RSAPrivateKey>(){

                @Override
                public Optional<RSAPrivateKey> getKey(String keyId) {
                    return new PEMFileRSAPrivateKeySupplier(authenticationDetailsProvider.getPrivateKey(), authenticationDetailsProvider.getPassphraseCharacters()).getKey(keyId);
                }
            };
        }
        return new PEMFileRSAPrivateKeySupplier(authenticationDetailsProvider.getPrivateKey(), authenticationDetailsProvider.getPassphraseCharacters());
    }

    private static AuthCachingPolicy getAuthCachingPolicy(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        return authenticationDetailsProvider.getClass().getAnnotation(AuthCachingPolicy.class);
    }

    public static Map<SigningStrategy, RequestSignerFactory> createDefaultRequestSignerFactories() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SigningStrategy s : SigningStrategy.values()) {
            builder.put((Object)s, (Object)new DefaultRequestSignerFactory(s));
        }
        return builder.build();
    }

    @ConstructorProperties(value={"signingStrategy"})
    public DefaultRequestSignerFactory(SigningStrategy signingStrategy) {
        this.signingStrategy = signingStrategy;
    }
}

