/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import lombok.NonNull;

public class DefaultRetryCondition
implements RetryCondition {
    private static final Multimap<Integer, String> RETRYABLE_SERVICE_ERRORS = ImmutableSetMultimap.builder().put((Object)400, (Object)"RelatedResourceNotAuthorizedOrNotFound").put((Object)401, (Object)"NotAuthenticated").put((Object)404, (Object)"NotAuthorizedOrNotFound").put((Object)409, (Object)"IncorrectState").put((Object)409, (Object)"NotAuthorizedOrResourceAlreadyExists").put((Object)429, (Object)"TooManyRequests").put((Object)500, (Object)"InternalServerError").build();
    private static final String PROCESSING_EXCEPTION_MSG = ".*processing(\\s)+exception.*";

    @Override
    public boolean shouldBeRetried(@NonNull BmcException exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        return exception.isClientSide() || exception.isTimeout() || exception.getStatusCode() >= 500 || RETRYABLE_SERVICE_ERRORS.containsEntry((Object)exception.getStatusCode(), (Object)exception.getServiceCode()) || DefaultRetryCondition.isProcessingException(exception);
    }

    public static boolean isProcessingException(BmcException exception) {
        return exception.getStatusCode() == -1 && exception.getMessage().toLowerCase().matches(PROCESSING_EXCEPTION_MSG);
    }
}

