/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecution;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInstanceAgentCommandExecutionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetInstanceAgentCommandExecutionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetInstanceAgentCommandExecutionRequest interceptRequest(GetInstanceAgentCommandExecutionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetInstanceAgentCommandExecutionRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getInstanceAgentCommandId(), (String)"instanceAgentCommandId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getInstanceId(), (String)"instanceId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180530").path("instanceAgentCommands").path(HttpUtils.encodePathSegment((String)request.getInstanceAgentCommandId())).path("status");
        target = target.queryParam("instanceId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getInstanceId())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetInstanceAgentCommandExecutionResponse> fromResponse() {
        Function<Response, GetInstanceAgentCommandExecutionResponse> transformer = new Function<Response, GetInstanceAgentCommandExecutionResponse>(){

            public GetInstanceAgentCommandExecutionResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InstanceAgentCommandExecution.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetInstanceAgentCommandExecutionResponse.Builder builder = GetInstanceAgentCommandExecutionResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.instanceAgentCommandExecution((InstanceAgentCommandExecution)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetInstanceAgentCommandExecutionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

