/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDatabaseDataguardAssociation;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseDataguardAssociationRequest;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseDataguardAssociationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAutonomousDatabaseDataguardAssociationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAutonomousDatabaseDataguardAssociationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAutonomousDatabaseDataguardAssociationRequest interceptRequest(GetAutonomousDatabaseDataguardAssociationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAutonomousDatabaseDataguardAssociationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousDatabaseId(), (String)"autonomousDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousDatabaseDataguardAssociationId(), (String)"autonomousDatabaseDataguardAssociationId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDatabases").path(HttpUtils.encodePathSegment((String)request.getAutonomousDatabaseId())).path("autonomousDatabaseDataguardAssociations").path(HttpUtils.encodePathSegment((String)request.getAutonomousDatabaseDataguardAssociationId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAutonomousDatabaseDataguardAssociationResponse> fromResponse() {
        Function<Response, GetAutonomousDatabaseDataguardAssociationResponse> transformer = new Function<Response, GetAutonomousDatabaseDataguardAssociationResponse>(){

            public GetAutonomousDatabaseDataguardAssociationResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetAutonomousDatabaseDataguardAssociationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousDatabaseDataguardAssociation.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetAutonomousDatabaseDataguardAssociationResponse.Builder builder = GetAutonomousDatabaseDataguardAssociationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.autonomousDatabaseDataguardAssociation((AutonomousDatabaseDataguardAssociation)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetAutonomousDatabaseDataguardAssociationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

