/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.Update;
import com.oracle.bmc.database.requests.GetCloudVmClusterUpdateRequest;
import com.oracle.bmc.database.responses.GetCloudVmClusterUpdateResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCloudVmClusterUpdateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetCloudVmClusterUpdateConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetCloudVmClusterUpdateRequest interceptRequest(GetCloudVmClusterUpdateRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetCloudVmClusterUpdateRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCloudVmClusterId(), (String)"cloudVmClusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUpdateId(), (String)"updateId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("cloudVmClusters").path(HttpUtils.encodePathSegment((String)request.getCloudVmClusterId())).path("updates").path(HttpUtils.encodePathSegment((String)request.getUpdateId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetCloudVmClusterUpdateResponse> fromResponse() {
        Function<Response, GetCloudVmClusterUpdateResponse> transformer = new Function<Response, GetCloudVmClusterUpdateResponse>(){

            public GetCloudVmClusterUpdateResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetCloudVmClusterUpdateResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Update.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetCloudVmClusterUpdateResponse.Builder builder = GetCloudVmClusterUpdateResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.update((Update)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetCloudVmClusterUpdateResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

